DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.09275949882143E-11   0.00000000000000E+00  -1.13598891641912E-13   1.47974947654899E-22
      1.09276431119059E-08   1.09275295130144E-08  -7.99416023833535E-19  -2.46304709481801E-01  -2.46304709481827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57730110060830E-11   0.00000000000000E+00   2.57730110060830E-11
      3.71361512117044E-18  -2.46304709481801E-01  -2.42853835801531E-01   0.00000000000000E+00   1.25917340127328E-13
     -9.82500733676775E-23  -1.09534284413605E-08  -1.09533025240205E-08  -2.91419909733690E-18
      1.17500000000000E-09
      0.00000000000000E+00  -9.88047313931131E-12   0.00000000000000E+00  -7.70444288004450E-14   1.35419981016251E-22
      9.88050970492316E-09   9.88043266049449E-09  -8.08679659960902E-19  -2.42051569355066E-01  -2.42051569355093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71332099231771E-11   0.00000000000000E+00   2.71332099231771E-11
      3.73193003786859E-18  -2.42051569355066E-01  -2.38930159062339E-01   0.00000000000000E+00   1.06144960609986E-13
     -9.81120347928424E-23  -9.90767201537818E-09  -9.90756587041767E-09  -2.92325037790768E-18
      2.08625000000000E-09
      0.00000000000000E+00  -8.88974395905372E-12   0.00000000000000E+00   4.41320625062716E-13   1.26249044421985E-22
      8.88982426952892E-09   8.89026559015411E-09  -8.18666931020043E-19  -2.37256267338218E-01  -2.37256267338245E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66401452560999E-11   0.00000000000000E+00   2.66401452560999E-11
      3.75620587023321E-18  -2.37256267338036E-01  -2.34447122388554E-01   0.00000000000000E+00  -4.05059264634842E-13
     -9.79152091704152E-23  -8.91650067614548E-09  -8.91690573541022E-09  -2.93753893921316E-18
      3.31643750000000E-09
      0.00000000000000E+00  -7.97340901593423E-12   0.00000000000000E+00   5.00266709372564E-13   1.20341416395035E-22
      7.97342706499648E-09   7.97392733170597E-09  -8.29223136726994E-19  -2.31974899935074E-01  -2.31974899935098E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45542838263391E-11   0.00000000000000E+00   2.45542838263391E-11
      3.78641224326782E-18  -2.31974899935401E-01  -2.29455119572114E-01   0.00000000000000E+00  -4.61883739680956E-13
     -9.76578583487168E-23  -7.99801973179254E-09  -7.99848161553231E-09  -2.95718910654083E-18
      4.97719062500000E-09
      0.00000000000000E+00  -7.14230598894332E-12   0.00000000000000E+00  -2.49511037377343E-14   1.17290148343329E-22
      7.14231600739372E-09   7.14229105629010E-09  -8.40153686402432E-19  -2.26319232763525E-01  -2.26319232763546E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12451343445438E-11   0.00000000000000E+00   2.12451343445438E-11
      3.82169516652157E-18  -2.26319232763955E-01  -2.24062334577772E-01   0.00000000000000E+00   6.15801354491300E-14
     -9.73477249675935E-23  -7.16359777076999E-09  -7.16353619063464E-09  -2.98154148011914E-18
      7.21920734375000E-09
      0.00000000000000E+00  -6.40304769915994E-12   0.00000000000000E+00  -1.64646049651741E-14   1.16465683246582E-22
      6.40312369203575E-09   6.40310722743090E-09  -8.51180715036091E-19  -2.20472430858956E-01  -2.20472430858973E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72031219378063E-11   0.00000000000000E+00   1.72031219378063E-11
      3.86026485352082E-18  -2.20472430859472E-01  -2.18449687330403E-01   0.00000000000000E+00   4.69251545446991E-14
     -9.70041774280126E-23  -6.42035727452315E-09  -6.42031034936870E-09  -3.00908413848473E-18
      1.02459299140625E-08
      0.00000000000000E+00  -5.76233881240023E-12   0.00000000000000E+00  -1.05893886893798E-14   1.17123520906643E-22
      5.76239269268187E-09   5.76238210329330E-09  -8.61914758791561E-19  -2.14693458931561E-01  -2.14693458931574E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29705876847502E-11   0.00000000000000E+00   1.29705876847502E-11
      3.89952322401647E-18  -2.14693458932012E-01  -2.12873910579399E-01   0.00000000000000E+00   3.34141754927735E-14
     -9.66557934094167E-23  -5.77538610515344E-09  -5.77535269097805E-09  -3.03760846522491E-18
      1.43320053839844E-08
      0.00000000000000E+00  -5.22670030500593E-12   0.00000000000000E+00  -6.56829210831794E-15   1.18549438971729E-22
      5.22674035429282E-09   5.22673378600083E-09  -8.71856379051747E-19  -2.09300890690393E-01  -2.09300890690402E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04462043603579E-12   0.00000000000000E+00   9.04462043603579E-12
      3.93648022571492E-18  -2.09300890690965E-01  -2.07651336410534E-01   0.00000000000000E+00   2.20094432395219E-14
     -9.63339682925282E-23  -5.23580041588001E-09  -5.23577840643687E-09  -3.06462384666317E-18
      1.93320053839844E-08
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00  -4.00831696939780E-15   1.20059619444635E-22
      4.82733869462152E-09   4.82733468630467E-09  -8.79920421745095E-19  -2.04918302155683E-01  -2.04918302155689E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97971234194659E-12   0.00000000000000E+00   5.97971234194659E-12
      3.96637878742464E-18  -2.04918302156414E-01  -2.03395545166252E-01   0.00000000000000E+00   1.37876113888324E-14
     -9.60808874626349E-23  -4.83332818625792E-09  -4.83331439864662E-09  -3.08645836567955E-18
      2.43320053839844E-08
      0.00000000000000E+00  -4.57294946556276E-12   0.00000000000000E+00   1.49059914000343E-13   1.21194403216834E-22
      4.57300094011035E-09   4.57315000002447E-09  -8.85376491559667E-19  -2.01955532767042E-01  -2.01955532767046E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00404024969070E-12   0.00000000000000E+00   4.00404024969070E-12
      3.98639898867310E-18  -2.01955532781492E-01  -2.00513527526967E-01   0.00000000000000E+00  -1.43418323829184E-13
     -9.59157946624307E-23  -4.57701062195023E-09  -4.57715404027415E-09  -3.10102249711343E-18
      2.93320053839844E-08
      0.00000000000000E+00  -4.40579204384506E-12   0.00000000000000E+00   6.20687166048736E-14   1.22002956615160E-22
      4.40579465359479E-09   4.40585672231151E-09  -8.89112976561194E-19  -1.99930064361720E-01  -1.99930064361723E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71006168523400E-12   0.00000000000000E+00   2.71006168523400E-12
      3.99994929709927E-18  -1.99930064367906E-01  -1.98541145367752E-01   0.00000000000000E+00  -5.82139871400902E-14
     -9.58073857203818E-23  -4.40850857000951E-09  -4.40856678399675E-09  -3.11083632053807E-18
      3.43320053839844E-08
      0.00000000000000E+00  -4.29355777497746E-12   0.00000000000000E+00  -1.12886692507514E-15   1.22565599976289E-22
      4.29354986225438E-09   4.29354873338757E-09  -8.91690044159592E-19  -1.98535543526611E-01  -1.98535543526613E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84977695131249E-12   0.00000000000000E+00   1.84977695131249E-12
      4.00919818185584E-18  -1.98535543529971E-01  -1.97182258474831E-01   0.00000000000000E+00   3.85377371164045E-15
     -9.57349736113109E-23  -4.29540236411250E-09  -4.29539851033889E-09  -3.11750813769624E-18
      3.93320053839844E-08
      0.00000000000000E+00  -4.21714295362080E-12   0.00000000000000E+00   3.85782554588415E-14   1.22953876703074E-22
      4.21717922981728E-09   4.21721780807286E-09  -8.93474932865033E-19  -1.97571096208852E-01  -1.97571096208854E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27065692523892E-12   0.00000000000000E+00   1.27065692523892E-12
      4.01555146648203E-18  -1.97571096212824E-01  -1.96242054290759E-01   0.00000000000000E+00  -3.68813763234977E-14
     -9.56856968592993E-23  -4.21845158362168E-09  -4.21848846499810E-09  -3.12207653361699E-18
      4.43320053839844E-08
      0.00000000000000E+00  -4.16469960867530E-12   0.00000000000000E+00   2.21654987975140E-13   1.23221206499599E-22
      4.16474185386069E-09   4.16496350884878E-09  -8.94714001366585E-19  -1.96902274720391E-01  -1.96902274720392E-01
      0.00000000000000E+00   0.00000000000000E+00   8.76906389039757E-13   0.00000000000000E+00   8.76906389039757E-13
      4.01993599842723E-18  -1.96902274718351E-01  -1.95589877275320E-01   0.00000000000000E+00  -2.21180187859070E-13
     -9.56513769550674E-23  -4.16561923504987E-09  -4.16584041523782E-09  -3.12522199706064E-18
      4.93320053839844E-08
      0.00000000000000E+00  -4.12878831642716E-12   0.00000000000000E+00   8.39343339591958E-15   1.23407839243237E-22
      4.12871174621717E-09   4.12872013965069E-09  -8.95577269465292E-19  -1.96436874066690E-01  -1.96436874066690E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07277714081052E-13   0.00000000000000E+00   6.07277714081052E-13
      4.02297238699763E-18  -1.96436874058204E-01  -1.95135912982124E-01   0.00000000000000E+00  -7.56867316399492E-15
     -9.56293012490053E-23  -4.12931984869151E-09  -4.12932741736477E-09  -3.12739511753234E-18
      5.43320053839844E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00   4.99528367436553E-14   1.23535513013687E-22
      4.10366242239978E-09   4.10371237523665E-09  -8.96178460284864E-19  -1.96112917116110E-01  -1.96112917116111E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21718241035740E-13   0.00000000000000E+00   4.21718241035740E-13
      4.02508097820281E-18  -1.96112917098577E-01  -1.94819906306161E-01   0.00000000000000E+00  -4.95224089031320E-14
     -9.56132412127424E-23  -4.10408457106869E-09  -4.10413409347769E-09  -3.12890251791795E-18
      5.93320053839844E-08
      0.00000000000000E+00  -4.08626420310007E-12   0.00000000000000E+00  -1.74944168376764E-16   1.23624601470986E-22
      4.08630410444038E-09   4.08630392949634E-09  -8.96597884117038E-19  -1.95887045219352E-01  -1.95887045219352E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93325415575659E-13   0.00000000000000E+00   2.93325415575659E-13
      4.02654760528069E-18  -1.95887045191705E-01  -1.94599543636697E-01   0.00000000000000E+00   5.81679542851785E-16
     -9.56024608459610E-23  -4.08659783659136E-09  -4.08659725491191E-09  -3.12994972116365E-18
      6.43320053839844E-08
      0.00000000000000E+00  -4.07423254252589E-12   0.00000000000000E+00   1.16296720538012E-14   1.23686195872802E-22
      4.07420549974566E-09   4.07421712941784E-09  -8.96890420804983E-19  -1.95729541223472E-01  -1.95729541223472E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04308811951377E-13   0.00000000000000E+00   2.04308811951377E-13
      4.02756914934044E-18  -1.95729541184201E-01  -1.94445879358896E-01   0.00000000000000E+00  -1.13820305598166E-14
     -9.55947693506907E-23  -4.07441005619914E-09  -4.07442143822980E-09  -3.13067872853546E-18
      6.93320053839844E-08
      0.00000000000000E+00  -4.06578282670279E-12   0.00000000000000E+00   3.95177807128487E-16   1.23729190966170E-22
      4.06578772831733E-09   4.06578812349526E-09  -8.97094639599748E-19  -1.95619621920433E-01  -1.95619621920433E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42412403048815E-13   0.00000000000000E+00   1.42412403048815E-13
      4.02828121135569E-18  -1.95619621870862E-01  -1.94338631584852E-01   0.00000000000000E+00  -2.00266386981560E-16
     -9.55895067436102E-23  -4.06593033563183E-09  -4.06593053589831E-09  -3.13118657175594E-18
      7.43320053839844E-08
      0.00000000000000E+00  -4.05990476352151E-12   0.00000000000000E+00   2.71609550275274E-15   1.23759074931665E-22
      4.05991435864934E-09   4.05991707474497E-09  -8.97237188340260E-19  -1.95542905161191E-01  -1.95542905161191E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93378471834838E-14   0.00000000000000E+00   9.93378471834838E-14
      4.02877790059161E-18  -1.95542905104465E-01  -1.94263778804962E-01   0.00000000000000E+00  -2.58737150388221E-15
     -9.55857949786017E-23  -4.06001382522055E-09  -4.06001641259215E-09  -3.13154071225135E-18
      7.93320053839844E-08
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   7.23549721417393E-17   1.23779936476771E-22
      4.05581941564342E-09   4.05581948799852E-09  -8.97336731332566E-19  -1.95489341232611E-01  -1.95489341232611E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93172932251751E-14   0.00000000000000E+00   6.93172932251751E-14
      4.02912448705773E-18  -1.95489341173379E-01  -1.94211514452521E-01   0.00000000000000E+00   2.25941089108507E-17
     -9.55832265575976E-23  -4.05588882788576E-09  -4.05588880529175E-09  -3.13178775572517E-18
      8.43320053839844E-08
      0.00000000000000E+00  -4.05292456349374E-12   0.00000000000000E+00   6.29201414506027E-16   1.23794473064351E-22
      4.05296060397914E-09   4.05296123318068E-09  -8.97406239281982E-19  -1.95451941288409E-01  -1.95451941288409E-01
      0.00000000000000E+00   0.00000000000000E+00   4.83858577067056E-14   0.00000000000000E+00   4.83858577067056E-14
      4.02936641634627E-18  -1.95451941232591E-01  -1.94175021780245E-01   0.00000000000000E+00  -5.64622709322802E-16
     -9.55814240741397E-23  -4.05300905441558E-09  -4.05300961903838E-09  -3.13196017706428E-18
      8.93320053839844E-08
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   6.85467783659783E-18   1.23804623646171E-22
      4.05096551595079E-09   4.05096552280559E-09  -8.97454784422934E-19  -1.95425822665127E-01  -1.95425822665127E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37810293659668E-14   0.00000000000000E+00   3.37810293659668E-14
      4.02953532149309E-18  -1.95425822622050E-01  -1.94149536327567E-01   0.00000000000000E+00   3.94342330341506E-17
     -9.55801707509287E-23  -4.05099934326910E-09  -4.05099930383496E-09  -3.13208053707016E-18
      9.43320053839844E-08
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00   1.42322787148767E-16   1.23811705433485E-22
      4.04957229510852E-09   4.04957243743143E-09  -8.97488687997383E-19  -1.95407582129151E-01  -1.95407582129151E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35885269782430E-14   0.00000000000000E+00   2.35885269782430E-14
      4.02965326412799E-18  -1.95407582110235E-01  -1.94131737963832E-01   0.00000000000000E+00  -1.10394575445797E-16
     -9.55792932965496E-23  -4.04959591556373E-09  -4.04959602595840E-09  -3.13216457613061E-18
      9.93320053839844E-08
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.27917652624400E-16   1.23816653690803E-22
      4.04859951391515E-09   4.04859964183292E-09  -8.97512367921274E-19  -1.95394842441880E-01  -1.95394842441880E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64727643749036E-14   0.00000000000000E+00   1.64727643749036E-14
      4.02973562794986E-18  -1.95394842457580E-01  -1.94119307029674E-01   0.00000000000000E+00  -1.06042839419508E-16
     -9.55786817710333E-23  -4.04861600855437E-09  -4.04861611459730E-09  -3.13222326002859E-18
      1.04332005383984E-07
      0.00000000000000E+00  -4.04796494768453E-12   0.00000000000000E+00   3.02722524957360E-17   1.23820104464498E-22
      4.04792017805078E-09   4.04792020832315E-09  -8.97528907690458E-19  -1.95385944318558E-01  -1.95385944318558E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15045006459139E-14   0.00000000000000E+00   1.15045006459139E-14
      4.02979315045309E-18  -1.95385944382922E-01  -1.94110624546439E-01   0.00000000000000E+00  -1.48167560666524E-17
     -9.55782541023578E-23  -4.04793169800695E-09  -4.04793171282380E-09  -3.13226424276264E-18
      1.09332005383984E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.79805646014372E-17   1.23822516161037E-22
      4.04744570966692E-09   4.04744573764761E-09  -8.97540460374877E-19  -1.95379729260623E-01  -1.95379729260623E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03504473309015E-15   0.00000000000000E+00   8.03504473309015E-15
      4.02983332567676E-18  -1.95379729383419E-01  -1.94104560122130E-01   0.00000000000000E+00  -1.71315991586537E-17
     -9.55779557217432E-23  -4.04745375556065E-09  -4.04745377269235E-09  -3.13229286530188E-18
      1.14332005383984E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.86443935514326E-16   1.23824202914268E-22
      4.04711427944661E-09   4.04711446589067E-09  -8.97548529232688E-19  -1.95375388371511E-01  -1.95375388371511E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61212868096406E-15   0.00000000000000E+00   5.61212868096406E-15
      4.02986138632016E-18  -1.95375388563931E-01  -1.94100324483736E-01   0.00000000000000E+00  -1.79797681889951E-16
     -9.55777472066114E-23  -4.04711989822157E-09  -4.04712007801935E-09  -3.13231285708747E-18
      1.19332005383984E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   5.38731845533772E-18   1.23825376536401E-22
      4.04688288739031E-09   4.04688289277776E-09  -8.97554165922824E-19  -1.95372356057584E-01  -1.95372356057584E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91988214973253E-15   0.00000000000000E+00   3.91988214973253E-15
      4.02988098573091E-18  -1.95372356320783E-01  -1.94097365674342E-01   0.00000000000000E+00  -3.51983786130438E-19
     -9.55776015918246E-23  -4.04688681230783E-09  -4.04688681265991E-09  -3.13232681980809E-18
      1.24332005383984E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   4.35400321843143E-17   1.23826198159676E-22
      4.04672120095395E-09   4.04672124449410E-09  -8.97558102975359E-19  -1.95370238069482E-01  -1.95370238069482E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73797019532236E-15   0.00000000000000E+00   2.73797019532236E-15
      4.02989467558189E-18  -1.95370238396632E-01  -1.94095299062094E-01   0.00000000000000E+00  -4.00431552043268E-17
     -9.55774998806823E-23  -4.04672394242105E-09  -4.04672398246430E-09  -3.13233657260653E-18
      1.29332005383984E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   6.99373475694383E-19   1.23826771215061E-22
      4.04660829231303E-09   4.04660829301252E-09  -8.97560853113217E-19  -1.95368758612974E-01  -1.95368758612974E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91245869694635E-15   0.00000000000000E+00   1.91245869694635E-15
      4.02990423787537E-18  -1.95368758989821E-01  -1.94093855487470E-01   0.00000000000000E+00   1.84193736225783E-18
     -9.55774288407183E-23  -4.04661020731306E-09  -4.04661020547122E-09  -3.13234338476216E-18
      1.34332005383984E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   9.95408316487921E-18   1.23827172021466E-22
      4.04652941318089E-09   4.04652942313510E-09  -8.97562774010139E-19  -1.95367725245297E-01  -1.95367725245297E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33582937057037E-15   0.00000000000000E+00   1.33582937057037E-15
      4.02991091702223E-18  -1.95367725642440E-01  -1.94092847172761E-01   0.00000000000000E+00  -8.18470857030468E-18
     -9.55773792178168E-23  -4.04653075077967E-09  -4.04653075896447E-09  -3.13234814301208E-18
      1.39332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.22942834021410E-19   1.23827451831894E-22
      4.04647432519047E-09   4.04647432506765E-09  -8.97564115730971E-19  -1.95367003453300E-01  -1.95367003453300E-01
      0.00000000000000E+00   0.00000000000000E+00   9.33038930490751E-16   0.00000000000000E+00   9.33038930490751E-16
      4.02991558221688E-18  -1.95367003827594E-01  -1.94092142840401E-01   0.00000000000000E+00   1.37802139432675E-18
     -9.55773445537172E-23  -4.04647525948451E-09  -4.04647525810659E-09  -3.13235146648590E-18
      1.44332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.17196156797504E-18   1.23827647441310E-22
      4.04643584591580E-09   4.04643584808788E-09  -8.97565052835636E-19  -1.95366499325916E-01  -1.95366499325916E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51663766504074E-16   0.00000000000000E+00   6.51663766504074E-16
      4.02991884053571E-18  -1.95366499618157E-01  -1.94091650842575E-01   0.00000000000000E+00  -1.29056484721933E-18
     -9.55773203353656E-23  -4.04643649846099E-09  -4.04643649975165E-09  -3.13235378770007E-18
      1.49332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.69699471290104E-19   1.23827784070984E-22
      4.04640897366216E-09   4.04640897349259E-09  -8.97565707306397E-19  -1.95366147245094E-01  -1.95366147245094E-01
      0.00000000000000E+00   0.00000000000000E+00   4.55096325946640E-16   0.00000000000000E+00   4.55096325946640E-16
      4.02992111601734E-18  -1.95366147382844E-01  -1.94091307135350E-01   0.00000000000000E+00   7.87062288034264E-19
     -9.55773034105816E-23  -4.04640942937588E-09  -4.04640942858891E-09  -3.13235540871095E-18
      1.54332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.24200899255196E-19   1.23827879571735E-22
      4.04639020705766E-09   4.04639020748199E-09  -8.97566164328477E-19  -1.95365901384232E-01  -1.95365901384232E-01
      0.00000000000000E+00   0.00000000000000E+00   3.17768366009473E-16   0.00000000000000E+00   3.17768366009473E-16
      4.02992270485917E-18  -1.95365901285391E-01  -1.94091066993615E-01   0.00000000000000E+00   1.27640718398471E-20
     -9.55772915777875E-23  -4.04639052526302E-09  -4.04639052525035E-09  -3.13235654053069E-18
      1.59332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.08797058377428E-19   1.23827946295502E-22
      4.04637710378031E-09   4.04637710367163E-09  -8.97566483423013E-19  -1.95365729724760E-01  -1.95365729724760E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21824501989983E-16   0.00000000000000E+00   2.21824501989983E-16
      4.02992381398168E-18  -1.95365729304457E-01  -1.94090899171122E-01   0.00000000000000E+00   4.11601424824180E-19
     -9.55772832990777E-23  -4.04637732590764E-09  -4.04637732549613E-09  -3.13235733055867E-18
      1.64332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.96366347082181E-20   1.23827992919228E-22
      4.04636795547001E-09   4.04636795551977E-09  -8.97566706174607E-19  -1.95365609896422E-01  -1.95365609896422E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54798157501263E-16   0.00000000000000E+00   1.54798157501263E-16
      4.02992458797247E-18  -1.95365609076844E-01  -1.94090781846819E-01   0.00000000000000E+00   1.60421206797285E-19
     -9.55772775013256E-23  -4.04636811047826E-09  -4.04636811031793E-09  -3.13235788179786E-18
      1.69332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -6.02385366970556E-20   1.23828025470357E-22
      4.04636156904180E-09   4.04636156898168E-09  -8.97566861650885E-19  -1.95365526262859E-01  -1.95365526262859E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07986291623667E-16   0.00000000000000E+00   1.07986291623667E-16
      4.02992512790393E-18  -1.95365524986655E-01  -1.94090699783435E-01   0.00000000000000E+00   2.07734274750834E-19
     -9.55772734359048E-23  -4.04636167717562E-09  -4.04636167696798E-09  -3.13235826625304E-18
      1.74332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.22085555850413E-20   1.23828048164106E-22
      4.04635710977871E-09   4.04635710976663E-09  -8.97566970179063E-19  -1.95365467889400E-01  -1.95365467889400E-01
      0.00000000000000E+00   0.00000000000000E+00   7.53159369006567E-17   0.00000000000000E+00   7.53159369006567E-17
      4.02992550448361E-18  -1.95365466135563E-01  -1.94090642347535E-01   0.00000000000000E+00   1.14766000522688E-19
     -9.55772705819864E-23  -4.04635718519723E-09  -4.04635718508256E-09  -3.13235853430455E-18
      1.79332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.85142150049098E-20   1.23828063932048E-22
      4.04635399384819E-09   4.04635399381980E-09  -8.97567045985802E-19  -1.95365427122968E-01  -1.95365427122968E-01
      0.00000000000000E+00   0.00000000000000E+00   5.25498082627504E-17   0.00000000000000E+00   5.25498082627504E-17
      4.02992576723265E-18  -1.95365424924696E-01  -1.94090602125520E-01   0.00000000000000E+00   1.04063054013429E-19
     -9.55772685780211E-23  -4.04635404647357E-09  -4.04635404636961E-09  -3.13235872124685E-18
      1.84332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.33913708535044E-20   1.23828074819865E-22
      4.04635181228619E-09   4.04635181227293E-09  -8.97567099038642E-19  -1.95365398601280E-01  -1.95365398601280E-01
      0.00000000000000E+00   0.00000000000000E+00   3.67322654200783E-17   0.00000000000000E+00   3.67322654200783E-17
      4.02992595089398E-18  -1.95365396063994E-01  -1.94090573957107E-01   0.00000000000000E+00   6.58883427551919E-20
     -9.55772671745353E-23  -4.04635184907099E-09  -4.04635184900519E-09  -3.13235885185534E-18
      1.89332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.54639265597059E-20   1.23828082254067E-22
      4.04635027852486E-09   4.04635027850952E-09  -8.97567136328746E-19  -1.95365378562602E-01  -1.95365378562602E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57998982790922E-17   0.00000000000000E+00   2.57998982790922E-17
      4.02992607989347E-18  -1.95365375879974E-01  -1.94090554259745E-01   0.00000000000000E+00   5.05245462858584E-20
     -9.55772662004508E-23  -4.04635030435986E-09  -4.04635030430943E-09  -3.13235894356472E-18
      1.94332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -9.68564307967625E-21   1.23828087235769E-22
      4.04634919165090E-09   4.04634919164133E-09  -8.97567162763312E-19  -1.95365364365554E-01  -1.95365364365554E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83093645911803E-17   0.00000000000000E+00   1.83093645911803E-17
      4.02992617144029E-18  -1.95365361830507E-01  -1.94090540555061E-01   0.00000000000000E+00   3.07961751923467E-20
     -9.55772655396494E-23  -4.04634920998140E-09  -4.04634920995070E-09  -3.13235900867698E-18
      1.99332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -7.54039018457424E-21   1.23828090475191E-22
      4.04634841107276E-09   4.04634841106535E-09  -8.97567181783016E-19  -1.95365354156811E-01  -1.95365354156811E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32453388017735E-17   0.00000000000000E+00   1.32453388017735E-17
      4.02992623766699E-18  -1.95365352164046E-01  -1.94090531136117E-01   0.00000000000000E+00   2.30381506560955E-20
     -9.55772651139084E-23  -4.04634842433363E-09  -4.04634842431068E-09  -3.13235905588397E-18
      2.04332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.88214203194784E-21   1.23828092488086E-22
      4.04634783896659E-09   4.04634783896184E-09  -8.97567195787698E-19  -1.95365346642077E-01  -1.95365346642076E-01
      0.00000000000000E+00   0.00000000000000E+00   9.88583936662528E-18   0.00000000000000E+00   9.88583936662528E-18
      4.02992628709618E-18  -1.95365345678223E-01  -1.94090524831597E-01   0.00000000000000E+00   1.20887652486140E-20
     -9.55772648706128E-23  -4.04634784885967E-09  -4.04634784884767E-09  -3.13235909130849E-18
      2.09332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.72165955833727E-21   1.23828093663636E-22
      4.04634740827761E-09   4.04634740827301E-09  -8.97567206426897E-19  -1.95365340929832E-01  -1.95365340929832E-01
      0.00000000000000E+00   0.00000000000000E+00   7.70705516438921E-18   0.00000000000000E+00   7.70705516438921E-18
      4.02992632563146E-18  -1.95365341547444E-01  -1.94090520837194E-01   0.00000000000000E+00   6.61361532984880E-21
     -9.55772647734308E-23  -4.04634741598659E-09  -4.04634741598007E-09  -3.13235911920456E-18
      2.14332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.27457400569493E-21   1.23828094312034E-22
      4.04634707451061E-09   4.04634707450746E-09  -8.97567214797035E-19  -1.95365336425463E-01  -1.95365336425463E-01
      0.00000000000000E+00   0.00000000000000E+00   6.31696158416673E-18   0.00000000000000E+00   6.31696158416673E-18
      4.02992635721627E-18  -1.95365339197568E-01  -1.94090518592910E-01   0.00000000000000E+00   6.05809907504297E-22
     -9.55772647951534E-23  -4.04634708082494E-09  -4.04634708082442E-09  -3.13235914241923E-18
      2.19332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.57992290073249E-21   1.23828094696596E-22
      4.04634681015851E-09   4.04634681015406E-09  -8.97567221574223E-19  -1.95365332760164E-01  -1.95365332760164E-01
      0.00000000000000E+00   0.00000000000000E+00   5.40943188271071E-18   0.00000000000000E+00   5.40943188271071E-18
      4.02992638426343E-18  -1.95365338213320E-01  -1.94090517692234E-01   0.00000000000000E+00  -2.96092449886629E-21
     -9.55772649119261E-23  -4.04634681556043E-09  -4.04634681556349E-09  -3.13235916268920E-18
      2.24332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.82238834643323E-21   1.23828095053414E-22
      4.04634660081374E-09   4.04634660081104E-09  -8.97567227104978E-19  -1.95365329742687E-01  -1.95365329742687E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73402913577826E-18   0.00000000000000E+00   4.73402913577826E-18
      4.02992640793357E-18  -1.95365338268454E-01  -1.94090517813537E-01   0.00000000000000E+00  -6.46822095204777E-21
     -9.55772650986997E-23  -4.04634660553850E-09  -4.04634660554507E-09  -3.13235918082859E-18
      2.29332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.67861060468179E-22   1.23828095600575E-22
      4.04634644236933E-09   4.04634644236888E-09  -8.97567231471124E-19  -1.95365327325167E-01  -1.95365327325167E-01
      0.00000000000000E+00   0.00000000000000E+00   4.07784680813068E-18   0.00000000000000E+00   4.07784680813068E-18
      4.02992642832281E-18  -1.95365339072730E-01  -1.94090518667938E-01   0.00000000000000E+00  -1.13727665201976E-20
     -9.55772653256048E-23  -4.04634644643525E-09  -4.04634644644672E-09  -3.13235919685168E-18
      2.34332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.22533626574454E-21   1.23828096537964E-22
      4.04634633872646E-09   4.04634633872536E-09  -8.97567234542022E-19  -1.95365325575941E-01  -1.95365325575941E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25731600620235E-18   0.00000000000000E+00   3.25731600620235E-18
      4.02992644460938E-18  -1.95365340332185E-01  -1.94090519960305E-01   0.00000000000000E+00  -1.01263983633247E-20
     -9.55772655554751E-23  -4.04634634197246E-09  -4.04634634198268E-09  -3.13235921006736E-18
      2.39332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.70931475267491E-23   1.23828098038585E-22
      4.04634629964043E-09   4.04634629964060E-09  -8.97567236024305E-19  -1.95365324653827E-01  -1.95365324653827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.11831947843015E-18   0.00000000000000E+00   2.11831947843015E-18
      4.02992645520098E-18  -1.95365341721500E-01  -1.94090521362293E-01   0.00000000000000E+00  -8.98153194189767E-21
     -9.55772657425737E-23  -4.04634630174984E-09  -4.04634630175892E-09  -3.13235921917668E-18
      2.44332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.39970943971755E-22   1.23828100232207E-22
      4.04634633842016E-09   4.04634633842083E-09  -8.97567235517359E-19  -1.95365324779379E-01  -1.95365324779379E-01
      0.00000000000000E+00   0.00000000000000E+00   5.43422507039521E-19   0.00000000000000E+00   5.43422507039521E-19
      4.02992645791810E-18  -1.95365342868548E-01  -1.94090522497620E-01   0.00000000000000E+00  -5.89578774133427E-21
     -9.55772658329135E-23  -4.04634633895826E-09  -4.04634633896425E-09  -3.13235922240074E-18
      2.49332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.22466682667148E-22   1.23828103182681E-22
      4.04634646922202E-09   4.04634646922257E-09  -8.97567232580408E-19  -1.95365326199790E-01  -1.95365326199790E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53516707264521E-18   0.00000000000000E+00  -1.53516707264521E-18
      4.02992645024226E-18  -1.95365343352394E-01  -1.94090522940911E-01   0.00000000000000E+00   1.50012249548800E-21
     -9.55772657664224E-23  -4.04634646768880E-09  -4.04634646768740E-09  -3.13235921766185E-18
      2.54332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.32251084192123E-21   1.23828106860808E-22
      4.04634670384927E-09   4.04634670385372E-09  -8.97567226815016E-19  -1.95365329145279E-01  -1.95365329145279E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.11842412661107E-18   0.00000000000000E+00  -4.11842412661107E-18
      4.02992642965014E-18  -1.95365342716407E-01  -1.94090522231816E-01   0.00000000000000E+00   9.81732100674133E-21
     -9.55772654812658E-23  -4.04634669974501E-09  -4.04634669973529E-09  -3.13235920283512E-18
      2.59332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.27921689728975E-21   1.23828111115491E-22
      4.04634704805875E-09   4.04634704806115E-09  -8.97567217963926E-19  -1.95365333776228E-01  -1.95365333776228E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.12122462463568E-18   0.00000000000000E+00  -7.12122462463568E-18
      4.02992639404402E-18  -1.95365340498175E-01  -1.94090519906084E-01   0.00000000000000E+00   2.29243041149871E-20
     -9.55772649205486E-23  -4.04634704096276E-09  -4.04634704093993E-09  -3.13235917608009E-18
      2.64332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.55248999926059E-21   1.23828115649699E-22
      4.04634749755447E-09   4.04634749755914E-09  -8.97567206020683E-19  -1.95365340123747E-01  -1.95365340123747E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03557634769878E-17   0.00000000000000E+00  -1.03557634769878E-17
      4.02992634226520E-18  -1.95365336277156E-01  -1.94090515544465E-01   0.00000000000000E+00   3.57638164338820E-20
     -9.55772640411800E-23  -4.04634748723905E-09  -4.04634748720338E-09  -3.13235913624452E-18
      2.69332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.56166363778994E-20   1.23828120002152E-22
      4.04634803393920E-09   4.04634803395494E-09  -8.97567191346001E-19  -1.95365348025775E-01  -1.95365348025775E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35186584105408E-17   0.00000000000000E+00  -1.35186584105408E-17
      4.02992627467191E-18  -1.95365329737092E-01  -1.94090508836404E-01   0.00000000000000E+00   3.68364428814330E-20
     -9.55772628252122E-23  -4.04634802047302E-09  -4.04634802043628E-09  -3.13235908332591E-18
      2.74332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.18246587990721E-20   1.23828123571352E-22
      4.04634862241525E-09   4.04634862237354E-09  -8.97567174745218E-19  -1.95365357082064E-01  -1.95365357082064E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62109835053606E-17   0.00000000000000E+00  -1.62109835053606E-17
      4.02992619361699E-18  -1.95365320740605E-01  -1.94090499655358E-01   0.00000000000000E+00   1.08779684206496E-19
     -9.55772612896746E-23  -4.04634860627124E-09  -4.04634860616256E-09  -3.13235901887177E-18
      2.76832005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   8.30059000174552E-16   1.23828152281123E-22
      4.04634813314758E-09   4.04634896320671E-09  -8.97567151238678E-19  -1.95365367805595E-01  -1.95365367805595E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63755410944241E-17   0.00000000000000E+00  -1.63755410944241E-17
      4.02992615267814E-18  -1.95365323238895E-01  -1.94090502308008E-01   0.00000000000000E+00  -8.31766362695349E-16
     -9.55768983164743E-23  -4.04634811506471E-09  -4.04634894683117E-09  -3.13235900143946E-18
      2.77675755383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   9.57275669011941E-20   1.23828155127447E-22
      4.04634976465215E-09   4.04634976474800E-09  -8.97567149667746E-19  -1.95365369310516E-01  -1.95365369310516E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.04373405855207E-17   0.00000000000000E+00  -3.04373405855207E-17
      4.02992612699663E-18  -1.95365319719790E-01  -1.94090498279127E-01   0.00000000000000E+00   2.28561790763319E-20
     -9.55772600861198E-23  -4.04634973433342E-09  -4.04634973431066E-09  -3.13235897732888E-18
      2.78814817883985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.73910878881064E-20   1.23828133552852E-22
      4.04634934650151E-09   4.04634934648425E-09  -8.97567156623353E-19  -1.95365366688855E-01  -1.95365366688855E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.82701908073796E-18   0.00000000000000E+00  -3.82701908073796E-18
      4.02992612263742E-18  -1.95365315998956E-01  -1.94090494681685E-01   0.00000000000000E+00   2.22672861247353E-20
     -9.55772601779635E-23  -4.04634934267939E-09  -4.04634934265722E-09  -3.13235896601406E-18
      2.80352552258985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.89117418777817E-20   1.23828093205168E-22
      4.04634815417299E-09   4.04634815413420E-09  -8.97567181588806E-19  -1.95365355310778E-01  -1.95365355310778E-01
      0.00000000000000E+00   0.00000000000000E+00   3.17323933718125E-17   0.00000000000000E+00   3.17323933718125E-17
      4.02992617143341E-18  -1.95365313124712E-01  -1.94090492171896E-01   0.00000000000000E+00  -8.51723008448589E-20
     -9.55772609328796E-23  -4.04634818578132E-09  -4.04634818586659E-09  -3.13235898984460E-18
      2.82428493665235E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -6.19206307723071E-20   1.23828028761690E-22
      4.04634557478144E-09   4.04634557471965E-09  -8.97567240622144E-19  -1.95365326666888E-01  -1.95365326666888E-01
      0.00000000000000E+00   0.00000000000000E+00   8.13143795203706E-17   0.00000000000000E+00   8.13143795203706E-17
      4.02992634023729E-18  -1.95365314833039E-01  -1.94090494677265E-01   0.00000000000000E+00  -2.31663994704766E-19
     -9.55772634997702E-23  -4.04634565580227E-09  -4.04634565603403E-09  -3.13235909961516E-18
      2.85231014563672E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.93091823868203E-20   1.23827934418616E-22
      4.04634056882428E-09   4.04634056873509E-09  -8.97567361930801E-19  -1.95365265499345E-01  -1.95365265499345E-01
      0.00000000000000E+00   0.00000000000000E+00   1.48731134578649E-16   0.00000000000000E+00   1.48731134578649E-16
      4.02992675705941E-18  -1.95365330864766E-01  -1.94090512264928E-01   0.00000000000000E+00  -4.44399287393926E-19
     -9.55772698835840E-23  -4.04634071702173E-09  -4.04634071746623E-09  -3.13235939512861E-18
      2.89014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.18750172246456E-19   1.23827805647242E-22
      4.04633147968364E-09   4.04633147956501E-09  -8.97567592588752E-19  -1.95365145874359E-01  -1.95365145874359E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37356527429885E-16   0.00000000000000E+00   2.37356527429885E-16
      4.02992765507486E-18  -1.95365384669913E-01  -1.94090568905776E-01   0.00000000000000E+00  -7.54947047496144E-19
     -9.55772841870441E-23  -4.04633171616650E-09  -4.04633171692154E-09  -3.13236006248611E-18
      2.94014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.48182475020625E-19   1.23827651566954E-22
      4.04631653127375E-09   4.04631653112569E-09  -8.97567988962443E-19  -1.95364935453394E-01  -1.95364935453394E-01
      0.00000000000000E+00   0.00000000000000E+00   3.42020985535682E-16   0.00000000000000E+00   3.42020985535682E-16
      4.02992936517979E-18  -1.95365522824378E-01  -1.94090711736919E-01   0.00000000000000E+00  -1.18287242034117E-18
     -9.55773131932366E-23  -4.04631687196371E-09  -4.04631687314667E-09  -3.13236137621734E-18
      2.99014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.65272258207565E-19   1.23827532388334E-22
      4.04630011360048E-09   4.04630011343534E-09  -8.97568441681070E-19  -1.95364690663959E-01  -1.95364690663959E-01
      0.00000000000000E+00   0.00000000000000E+00   4.23372032141341E-16   0.00000000000000E+00   4.23372032141341E-16
      4.02993148203994E-18  -1.95365731712809E-01  -1.94090925772289E-01   0.00000000000000E+00  -1.57689438468714E-18
     -9.55773513882217E-23  -4.04630053523038E-09  -4.04630053680737E-09  -3.13236304035888E-18
      3.04014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.63121975947193E-19   1.23827469233545E-22
      4.04628413779722E-09   4.04628413763422E-09  -8.97568902568811E-19  -1.95364436631459E-01  -1.95364436631459E-01
      0.00000000000000E+00   0.00000000000000E+00   4.67876298293514E-16   0.00000000000000E+00   4.67876298293514E-16
      4.02993382142144E-18  -1.95366005969479E-01  -1.94091205048306E-01   0.00000000000000E+00  -1.88108411265822E-18
     -9.55773964481118E-23  -4.04628460362934E-09  -4.04628460551052E-09  -3.13236491885263E-18
      3.09014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.30647364399791E-19   1.23827485201914E-22
      4.04627100262894E-09   4.04627100249842E-09  -8.97569308906610E-19  -1.95364206563827E-01  -1.95364206563827E-01
      0.00000000000000E+00   0.00000000000000E+00   4.59923407153088E-16   0.00000000000000E+00   4.59923407153088E-16
      4.02993612103847E-18  -1.95366329261874E-01  -1.94091532481616E-01   0.00000000000000E+00  -2.02715745477068E-18
     -9.55774443823872E-23  -4.04627146039457E-09  -4.04627146242182E-09  -3.13236681213186E-18
      3.14014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00  -4.30225621633448E-20   1.23827603724715E-22
      4.04626356595739E-09   4.04626356591449E-09  -8.97569583642898E-19  -1.95364041770892E-01  -1.95364041770892E-01
      0.00000000000000E+00   0.00000000000000E+00   3.83068660492676E-16   0.00000000000000E+00   3.83068660492676E-16
      4.02993803638177E-18  -1.95366672626235E-01  -1.94091878213248E-01   0.00000000000000E+00  -1.96740448042968E-18
     -9.55774893733309E-23  -4.04626394701565E-09  -4.04626394898315E-09  -3.13236845273888E-18
      3.19014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   5.32129706301039E-20   1.23827845827144E-22
      4.04626502482734E-09   4.04626502488068E-09  -8.97569637974346E-19  -1.95363990440255E-01  -1.95363990440255E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21969774876797E-16   0.00000000000000E+00   2.21969774876797E-16
      4.02993914623065E-18  -1.95366993453573E-01  -1.94092198631776E-01   0.00000000000000E+00  -1.56654166488667E-18
     -9.55775237718864E-23  -4.04626524528381E-09  -4.04626524685044E-09  -3.13236950825630E-18
      3.24014417776563E-07
      0.00000000000000E+00  -4.04621989767759E-12   0.00000000000000E+00   5.21557066073771E-19   1.23828226367974E-22
      4.04627868432616E-09   4.04627868484785E-09  -8.97569376908344E-19  -1.95364104820378E-01  -1.95364104820378E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.49716270311720E-17   0.00000000000000E+00  -3.49716270311720E-17
      4.02993897137252E-18  -1.95367235608610E-01  -1.94092436564272E-01   0.00000000000000E+00  -1.12110175609691E-18
     -9.55775383212952E-23  -4.04627864875502E-09  -4.04627864987622E-09  -3.13236959446417E-18
      3.29014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.34362045960385E-19   1.23828749399222E-22
      4.04630760235848E-09   4.04630760279297E-09  -8.97568708287171E-19  -1.95364436528919E-01  -1.95364436528919E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.92344094221017E-16   0.00000000000000E+00  -3.92344094221017E-16
      4.02993700965205E-18  -1.95367331209282E-01  -1.94092523166682E-01   0.00000000000000E+00   3.52093974951350E-19
     -9.55775226796216E-23  -4.04630721080087E-09  -4.04630721044887E-09  -3.13236830136487E-18
      3.34014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.65178437684531E-18   1.23829402987113E-22
      4.04635410582329E-09   4.04635410747519E-09  -8.97567555456892E-19  -1.95365029853322E-01  -1.95365029853322E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.44026542097348E-16   0.00000000000000E+00  -8.44026542097348E-16
      4.02993278951933E-18  -1.95367204591756E-01  -1.94092382040118E-01   0.00000000000000E+00   9.65235325374011E-19
     -9.55774662988390E-23  -4.04635326441379E-09  -4.04635326344866E-09  -3.13236523406244E-18
      3.39014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   9.07958170390846E-19   1.23830153898515E-22
      4.04641919676452E-09   4.04641919767260E-09  -8.97565873400319E-19  -1.95365913109407E-01  -1.95365913109407E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36939719235457E-15   0.00000000000000E+00  -1.36939719235457E-15
      4.02992594253337E-18  -1.95366778873951E-01  -1.94091935980292E-01   0.00000000000000E+00   4.00348494361912E-18
     -9.55773597023123E-23  -4.04641783227880E-09  -4.04641782827541E-09  -3.13236006913305E-18
      3.44014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   2.63017194961499E-18   1.23830943029722E-22
      4.04650187313820E-09   4.04650187576850E-09  -8.97563667537944E-19  -1.95367088434136E-01  -1.95367088434136E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.92987322983405E-15   0.00000000000000E+00  -1.92987322983405E-15
      4.02991629316722E-18  -1.95365985401719E-01  -1.94091116636576E-01   0.00000000000000E+00   4.77360970106961E-18
     -9.55771961451001E-23  -4.04649995066878E-09  -4.04649994589527E-09  -3.13235262562928E-18
      3.49014417776563E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   1.16418695671862E-18   1.23831682160307E-22
      4.04659843772202E-09   4.04659843888634E-09  -8.97561013831217E-19  -1.95368520722307E-01  -1.95368520722307E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46648422951288E-15   0.00000000000000E+00  -2.46648422951288E-15
      4.02990396074607E-18  -1.95364775994012E-01  -1.94089876974185E-01   0.00000000000000E+00   8.95705950770962E-18
     -9.55769736206469E-23  -4.04659598135907E-09  -4.04659597240211E-09  -3.13234294691486E-18
      3.54014417776563E-07
      0.00000000000000E+00  -4.04677096610084E-12   0.00000000000000E+00   2.09615120197249E-18   1.23832253527648E-22
      4.04670185910556E-09   4.04670186120184E-09  -8.97558077981413E-19  -1.95370126837719E-01  -1.95370126837719E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89903628675050E-15   0.00000000000000E+00  -2.89903628675050E-15
      4.02988946556464E-18  -1.95363137627525E-01  -1.94088206159840E-01   0.00000000000000E+00   1.03259809514031E-17
     -9.55766970601061E-23  -4.04669897249144E-09  -4.04669896216555E-09  -3.13233138758323E-18
      3.59014417776563E-07
      0.00000000000000E+00  -4.04677096610084E-12   0.00000000000000E+00   1.00563850266181E-18   1.23832512792752E-22
      4.04680132062030E-09   4.04680132162606E-09  -8.97555130826645E-19  -1.95371766658014E-01  -1.95371766658014E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.12791522255227E-15   0.00000000000000E+00  -3.12791522255227E-15
      4.02987382598853E-18  -1.95361108546800E-01  -1.94086145814604E-01   0.00000000000000E+00   1.32694329781069E-17
     -9.55763805566897E-23  -4.04679820698018E-09  -4.04679819371084E-09  -3.13231869516188E-18
      3.64014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   8.59622769642445E-19   1.23832297133348E-22
      4.04688206673982E-09   4.04688206759957E-09  -8.97552556292975E-19  -1.95373237887620E-01  -1.95373237887620E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.03902352654606E-15   0.00000000000000E+00  -3.03902352654606E-15
      4.02985863087089E-18  -1.95358794371813E-01  -1.94083806171369E-01   0.00000000000000E+00   1.39567917573867E-17
     -9.55760492806922E-23  -4.04687904253274E-09  -4.04687902857604E-09  -3.13230607457792E-18
      3.69014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   1.05114145633324E-18   1.23831438816401E-22
      4.04692571376082E-09   4.04692571481208E-09  -8.97550847783775E-19  -1.95374276898714E-01  -1.95374276898714E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.51285125311513E-15   0.00000000000000E+00  -2.51285125311513E-15
      4.02984606661463E-18  -1.95356381992022E-01  -1.94081379873935E-01   0.00000000000000E+00   1.26780888967638E-17
     -9.55757407624950E-23  -4.04692321463882E-09  -4.04692320196083E-09  -3.13229521883085E-18
      3.74014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   6.51861656369671E-18   1.23829785316582E-22
      4.04691116442220E-09   4.04691117094094E-09  -8.97550588570691E-19  -1.95374568031703E-01  -1.95374568031703E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43795394393222E-15   0.00000000000000E+00  -1.43795394393222E-15
      4.02983887684491E-18  -1.95354148553034E-01  -1.94079150679718E-01   0.00000000000000E+00   3.78284851809103E-18
     -9.55755050495739E-23  -4.04690973676975E-09  -4.04690973298699E-09  -3.13228828827422E-18
      3.79014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   2.80085306156277E-18   1.23827225425312E-22
      4.04681626046525E-09   4.04681626326623E-09  -8.97552412526570E-19  -1.95373763463252E-01  -1.95373763463252E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71142657678015E-16   0.00000000000000E+00   2.71142657678015E-16
      4.02984023255820E-18  -1.95352462275983E-01  -1.94077493764154E-01   0.00000000000000E+00   1.25860003042428E-18
     -9.55754033157164E-23  -4.04681653566739E-09  -4.04681653440889E-09  -3.13228782003163E-18
      3.84014417776563E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   3.04814832352622E-17   1.23823721481031E-22
      4.04662024703695E-09   4.04662027751856E-09  -8.97556941302173E-19  -1.95371515817671E-01  -1.95371515817671E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65173113908098E-15   0.00000000000000E+00   2.65173113908098E-15
      4.02985349121390E-18  -1.95351771704110E-01  -1.94076864197815E-01   0.00000000000000E+00  -3.62990131385676E-17
     -9.55755043975888E-23  -4.04662289295059E-09  -4.04662292924970E-09  -3.13229654991172E-18
      3.89014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   6.11264025531934E-18   1.23819343458962E-22
      4.04630712395210E-09   4.04630713006487E-09  -8.97564698229917E-19  -1.95367523744200E-01  -1.95367523744200E-01
      0.00000000000000E+00   0.00000000000000E+00   5.66828667783180E-15   0.00000000000000E+00   5.66828667783180E-15
      4.02988183264728E-18  -1.95352579742248E-01  -1.94077769937858E-01   0.00000000000000E+00  -2.41291580620627E-17
     -9.55758789239441E-23  -4.04631277422229E-09  -4.04631279835155E-09  -3.13231713441737E-18
      3.94014417776563E-07
      0.00000000000000E+00  -4.04585251872876E-12   0.00000000000000E+00   6.60558823427061E-17   1.23814306787474E-22
      4.04586962829696E-09   4.04586969435296E-09  -8.97575997768306E-19  -1.95361591006019E-01  -1.95361591006019E-01
      0.00000000000000E+00   0.00000000000000E+00   9.18692712685664E-15   0.00000000000000E+00   9.18692712685664E-15
      4.02992776728292E-18  -1.95355400215227E-01  -1.94080727139578E-01   0.00000000000000E+00  -1.01773288251093E-16
     -9.55765907427092E-23  -4.04587877950671E-09  -4.04587888128009E-09  -3.13235176951461E-18
      3.99014417776563E-07
      0.00000000000000E+00  -4.04530145030552E-12   0.00000000000000E+00   5.77212616529430E-18   1.23809000001854E-22
      4.04531396358305E-09   4.04531396935530E-09  -8.97590818903419E-19  -1.95353695376235E-01  -1.95353695376235E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29519151152028E-14   0.00000000000000E+00   1.29519151152028E-14
      4.02999252685850E-18  -1.95360694304800E-01  -1.94086195111032E-01   0.00000000000000E+00  -5.68967722002156E-17
     -9.55776857306381E-23  -4.04532686437355E-09  -4.04532692127042E-09  -3.13240170795507E-18
      4.04014417776563E-07
      0.00000000000000E+00  -4.04465853714506E-12   0.00000000000000E+00   6.72625669787399E-17   1.23804011546244E-22
      4.04466430781649E-09   4.04466437507918E-09  -8.97608667734163E-19  -1.95344063983078E-01  -1.95344063983078E-01
      0.00000000000000E+00   0.00000000000000E+00   1.65701220970457E-14   0.00000000000000E+00   1.65701220970457E-14
      4.03007537746898E-18  -1.95368788730502E-01  -1.94094493078034E-01   0.00000000000000E+00  -1.40849723552861E-16
     -9.55791782987224E-23  -4.04468080435146E-09  -4.04468094520128E-09  -3.13246670973481E-18
      4.09014417776563E-07
      0.00000000000000E+00  -4.04401562398461E-12   0.00000000000000E+00  -3.30505104480015E-18   1.23800127257398E-22
      4.04396736304017E-09   4.04396735973525E-09  -8.97628447805628E-19  -1.95333246388343E-01  -1.95333246388343E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95037014703327E-14   0.00000000000000E+00   1.95037014703327E-14
      4.03017289597633E-18  -1.95379776426393E-01  -1.94105699430441E-01   0.00000000000000E+00  -8.20613284336719E-17
     -9.55810364953629E-23  -4.04398678137529E-09  -4.04398686343672E-09  -3.13254444817070E-18
      4.14014417776563E-07
      0.00000000000000E+00  -4.04328086608695E-12   0.00000000000000E+00   6.38398639921822E-18   1.23798317737914E-22
      4.04329520251205E-09   4.04329520889616E-09  -8.97648354210362E-19  -1.95322175781762E-01  -1.95322175781762E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10842011509989E-14   0.00000000000000E+00   2.10842011509989E-14
      4.03027831698209E-18  -1.95393408401879E-01  -1.94119542680677E-01   0.00000000000000E+00  -1.07694860176521E-16
     -9.55831670051703E-23  -4.04331618540236E-09  -4.04331629309731E-09  -3.13262996277172E-18
      4.19014417776563E-07
      0.00000000000000E+00  -4.04272979766370E-12   0.00000000000000E+00  -1.31004906548975E-18   1.23799678821668E-22
      4.04274652959918E-09   4.04274652828925E-09  -8.97665818636410E-19  -1.95312204815476E-01  -1.95312204815476E-01
      0.00000000000000E+00   0.00000000000000E+00   2.05432416087030E-14   0.00000000000000E+00   2.05432416087030E-14
      4.03038103319013E-18  -1.95408984752146E-01  -1.94135292068746E-01   0.00000000000000E+00  -9.93733931057983E-17
     -9.55854020957469E-23  -4.04276697215737E-09  -4.04276707153086E-09  -3.13271521455372E-18
      4.24014417776563E-07
      0.00000000000000E+00  -4.04245426345208E-12   0.00000000000000E+00   6.65539454147443E-17   1.23805345695140E-22
      4.04244458348134E-09   4.04244465003541E-09  -8.97677530737578E-19  -1.95305101356834E-01  -1.95305101356834E-01
      0.00000000000000E+00   0.00000000000000E+00   1.70747231846749E-14   0.00000000000000E+00   1.70747231846749E-14
      4.03046640680605E-18  -1.95425260317570E-01  -1.94151663861021E-01   0.00000000000000E+00  -1.60036469955657E-16
     -9.55874908280212E-23  -4.04246156472203E-09  -4.04246172475860E-09  -3.13278887606848E-18
      4.29014417776563E-07
      0.00000000000000E+00  -4.04254610818929E-12   0.00000000000000E+00   7.98966919076048E-17   1.23816353927447E-22
      4.04253111267251E-09   4.04253119256933E-09  -8.97679570704185E-19  -1.95302985839368E-01  -1.95302985839368E-01
      0.00000000000000E+00   0.00000000000000E+00   9.92555091958436E-15   0.00000000000000E+00   9.92555091958436E-15
      4.03051603456065E-18  -1.95440383113729E-01  -1.94166761651013E-01   0.00000000000000E+00  -1.51043026190725E-16
     -9.55890978527070E-23  -4.04254096707713E-09  -4.04254111812025E-09  -3.13283646385647E-18
      4.34014417776563E-07
      0.00000000000000E+00  -4.04318902134974E-12   0.00000000000000E+00   4.28859682603359E-17   1.23833463727439E-22
      4.04315546872178E-09   4.04315551160787E-09  -8.97667668610738E-19  -1.95308200189664E-01  -1.95308200189664E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48699359643063E-15   0.00000000000000E+00  -1.48699359643063E-15
      4.03050859959267E-18  -1.95451886499965E-01  -1.94178071926576E-01   0.00000000000000E+00  -7.25013637055088E-17
     -9.55898124105626E-23  -4.04315395211282E-09  -4.04315402461428E-09  -3.13284093098193E-18
      4.39014417776563E-07
      0.00000000000000E+00  -4.04447484767065E-12   0.00000000000000E+00   3.01993037928505E-16   1.23856948077888E-22
      4.04445802150263E-09   4.04445832349579E-09  -8.97637626172375E-19  -1.95323088993590E-01  -1.95323088993590E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.74230147644349E-14   0.00000000000000E+00  -1.74230147644349E-14
      4.03042148451885E-18  -1.95456759539498E-01  -1.94182539607478E-01   0.00000000000000E+00  -2.76424470039632E-16
     -9.55891713583908E-23  -4.04444062405646E-09  -4.04444090048103E-09  -3.13278385834647E-18
      4.44014417776563E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   1.38094580106161E-16   1.23886339626316E-22
      4.04654841823685E-09   4.04654855633156E-09  -8.97585900397541E-19  -1.95349691886348E-01  -1.95349691886348E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.76581411425847E-14   0.00000000000000E+00  -3.76581411425847E-14
      4.03023319381313E-18  -1.95451615847387E-01  -1.94176743692374E-01   0.00000000000000E+00  -2.34890565705035E-17
     -9.55866981651657E-23  -4.04651087470126E-09  -4.04651089819042E-09  -3.13264729341559E-18
      4.49014417776563E-07
      0.00000000000000E+00  -4.04943446347985E-12   0.00000000000000E+00   5.43327304143823E-16   1.23920215349134E-22
      4.04947773920461E-09   4.04947828253204E-09  -8.97510336945757E-19  -1.95389350054578E-01  -1.95389350054578E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.13059156101532E-14   0.00000000000000E+00  -6.13059156101532E-14
      4.02992666423508E-18  -1.95432985284227E-01  -1.94157197667958E-01   0.00000000000000E+00  -3.48187719525988E-16
     -9.55819614370041E-23  -4.04941662842861E-09  -4.04941697661643E-09  -3.13241632728932E-18
      4.54014417776563E-07
      0.00000000000000E+00  -4.05320009770536E-12   0.00000000000000E+00   2.25643986670632E-16   1.23955939076884E-22
      4.05320846460081E-09   4.05320869024492E-09  -8.97411028749610E-19  -1.95442242034461E-01  -1.95442242034461E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.66753988121522E-14   0.00000000000000E+00  -8.66753988121522E-14
      4.02949328724102E-18  -1.95397732714922E-01  -1.94120777687608E-01   0.00000000000000E+00   1.05529697853175E-16
     -9.55746461116471E-23  -4.05312212037571E-09  -4.05312201484611E-09  -3.13208225849141E-18
      4.56514417776563E-07
      0.00000000000000E+00  -4.05522068192393E-12   0.00000000000000E+00   4.15267649219889E-17   1.23973860137861E-22
      4.05526339659036E-09   4.05526343811725E-09  -8.97355620729473E-19  -1.95471929883924E-01  -1.95471929883924E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95228801253707E-14   0.00000000000000E+00  -9.95228801253707E-14
      4.02924448004071E-18  -1.95375594083601E-01  -1.94097995675089E-01   0.00000000000000E+00   3.54530449584683E-16
     -9.55703166288654E-23  -4.05516426976748E-09  -4.05516391523713E-09  -3.13188885931124E-18
      4.57358167776563E-07
      0.00000000000000E+00  -4.05595543982159E-12   0.00000000000000E+00   4.27961954619142E-17   1.23979897700953E-22
      4.05597802369359E-09   4.05597806648991E-09  -8.97336274475495E-19  -1.95482315025853E-01  -1.95482315025853E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03867588104198E-13   0.00000000000000E+00  -1.03867588104198E-13
      4.02915684176324E-18  -1.95367595119394E-01  -1.94089772928660E-01   0.00000000000000E+00   3.73928119794241E-16
     -9.55687774140171E-23  -4.05587457282983E-09  -4.05587419890181E-09  -3.13182056728775E-18
      4.58497230276563E-07
      0.00000000000000E+00  -4.05696573193087E-12   0.00000000000000E+00   4.44531555128372E-17   1.23987983639110E-22
      4.05697944104723E-09   4.05697948550051E-09  -8.97309010528260E-19  -1.95496987573140E-01  -1.95496987573140E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09715952236319E-13   0.00000000000000E+00  -1.09715952236319E-13
      4.02903186843640E-18  -1.95355805582808E-01  -1.94077669727077E-01   0.00000000000000E+00   4.00534097143400E-16
     -9.55665559791219E-23  -4.05687017008227E-09  -4.05686976954827E-09  -3.13172285790814E-18
      4.60034964651563E-07
      0.00000000000000E+00  -4.05843524772619E-12   0.00000000000000E+00   4.79016326247578E-17   1.23998659753275E-22
      4.05839307461491E-09   4.05839312251666E-09  -8.97270220575671E-19  -1.95517935805407E-01  -1.95517935805407E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17500452357423E-13   0.00000000000000E+00  -1.17500452357423E-13
      4.02885118395173E-18  -1.95338018226411E-01  -1.94059439442175E-01   0.00000000000000E+00   4.35371745904109E-16
     -9.55632930228572E-23  -4.05827605743596E-09  -4.05827562206431E-09  -3.13158096337606E-18
      4.62110906057813E-07
      0.00000000000000E+00  -4.06036398720755E-12   0.00000000000000E+00   5.24102953634119E-17   1.24012292788067E-22
      4.06039714197791E-09   4.06039719438833E-09  -8.97214611339255E-19  -1.95548114119887E-01  -1.95548114119887E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27577105692835E-13   0.00000000000000E+00  -1.27577105692835E-13
      4.02858634135554E-18  -1.95310470133909E-01  -1.94031263120060E-01   0.00000000000000E+00   4.82044054890894E-16
     -9.55584083201742E-23  -4.06027009932660E-09  -4.06026961728264E-09  -3.13137173001628E-18
      4.64913426956250E-07
      0.00000000000000E+00  -4.06321117406098E-12   0.00000000000000E+00   5.70309849273767E-17   1.24028290242876E-22
      4.06321973209454E-09   4.06321978912565E-09  -8.97134967741644E-19  -1.95591645555885E-01  -1.95591645555885E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39722889888286E-13   0.00000000000000E+00  -1.39722889888286E-13
      4.02819476503663E-18  -1.95266692800254E-01  -1.93986600322677E-01   0.00000000000000E+00   5.42617601266294E-16
     -9.55509757164008E-23  -4.06308060885326E-09  -4.06308006623576E-09  -3.13105979729499E-18
      4.68696830169141E-07
      0.00000000000000E+00  -4.06706865302370E-12   0.00000000000000E+00   5.16323974933293E-17   1.24042621741082E-22
      4.06704350230048E-09   4.06704355393300E-09  -8.97024024173474E-19  -1.95652983561814E-01  -1.95652983561814E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51484065668296E-13   0.00000000000000E+00  -1.51484065668296E-13
      4.02762163973588E-18  -1.95195962122711E-01  -1.93914668624195E-01   0.00000000000000E+00   6.20967412669497E-16
     -9.55396372739575E-23  -4.06689269083466E-09  -4.06689206986734E-09  -3.13059761556241E-18
      4.73696830169141E-07
      0.00000000000000E+00  -4.07147720040966E-12   0.00000000000000E+00   4.97396800015869E-17   1.24041164626648E-22
      4.07146308636431E-09   4.07146313610411E-09  -8.96888210290495E-19  -1.95729739825678E-01  -1.95729739825678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53533668441205E-13   0.00000000000000E+00  -1.53533668441205E-13
      4.02685397139368E-18  -1.95086074747055E-01  -1.93803389443366E-01   0.00000000000000E+00   6.79411312270228E-16
     -9.55234031296518E-23  -4.07131028184689E-09  -4.07130960243567E-09  -3.12996576110318E-18
      4.78696830169141E-07
      0.00000000000000E+00  -4.07441623200030E-12   0.00000000000000E+00   2.99166187620648E-17   1.24011114387852E-22
      4.07440274882219E-09   4.07440277873893E-09  -8.96785503693602E-19  -1.95790324846012E-01  -1.95790324846012E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36230335231615E-13   0.00000000000000E+00  -1.36230335231615E-13
      4.02617281971752E-18  -1.94967461846313E-01  -1.93683844900247E-01   0.00000000000000E+00   6.77546959026962E-16
     -9.55075381667933E-23  -4.07426722595057E-09  -4.07426654840370E-09  -3.12938731602392E-18
      4.81196830169141E-07
      0.00000000000000E+00  -4.07542652410958E-12   0.00000000000000E+00   2.00992200287693E-17   1.23987908225276E-22
      4.07538526278651E-09   4.07538528288585E-09  -8.96745554347466E-19  -1.95814900716361E-01  -1.95814900716361E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21992195639036E-13   0.00000000000000E+00  -1.21992195639036E-13
      4.02586783922842E-18  -1.94907193583396E-01  -1.93623262589367E-01   0.00000000000000E+00   6.54262163268668E-16
     -9.54999393862249E-23  -4.07526394495228E-09  -4.07526329069021E-09  -3.12912228488095E-18
      4.84571830169141E-07
      0.00000000000000E+00  -4.07551836884679E-12   0.00000000000000E+00   2.04805263860680E-18   1.23939225756828E-22
      4.07550300056134E-09   4.07550300260952E-09  -8.96721119241337E-19  -1.95832956629528E-01  -1.95832956629528E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.07746751143225E-14   0.00000000000000E+00  -9.07746751143225E-14
      4.02556147469991E-18  -1.94828013773365E-01  -1.93544035833081E-01   0.00000000000000E+00   5.78910790399879E-16
     -9.54910151564515E-23  -4.07541280684511E-09  -4.07541222793441E-09  -3.12884035545857E-18
      4.89128080169141E-07
      0.00000000000000E+00  -4.07257933725615E-12   0.00000000000000E+00   1.10363873914115E-16   1.23836939283815E-22
      4.07260968490647E-09   4.07260979527046E-09  -8.96765742517901E-19  -1.95816747193751E-01  -1.95816747193751E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.29872350748468E-14   0.00000000000000E+00  -2.29872350748468E-14
      4.02545673911010E-18  -1.94738015014242E-01  -1.93454927262032E-01   0.00000000000000E+00   2.33900627051886E-16
     -9.54836027576533E-23  -4.07258704193592E-09  -4.07258680803539E-09  -3.12869099659220E-18
      4.94128080169141E-07
      0.00000000000000E+00  -4.06468068985630E-12   0.00000000000000E+00   2.84163085798092E-16   1.23677108390996E-22
      4.06465918793178E-09   4.06465947209499E-09  -8.96940568072070E-19  -1.95732123197964E-01  -1.95732123197964E-01
      0.00000000000000E+00   0.00000000000000E+00   8.53117921908849E-14   0.00000000000000E+00   8.53117921908849E-14
      4.02588329807105E-18  -1.94681033497083E-01  -1.93400416484821E-01   0.00000000000000E+00  -3.53199609580382E-16
     -9.54844376978687E-23  -4.06474443068747E-09  -4.06474478388718E-09  -3.12894272999898E-18
      4.99128080169141E-07
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   4.03052468589142E-16   1.23470738838233E-22
      4.05101668260543E-09   4.05101708565803E-09  -8.97270665427507E-19  -1.95563990131177E-01  -1.95563990131177E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27319328461145E-13   0.00000000000000E+00   2.27319328461145E-13
      4.02701989471336E-18  -1.94690581098717E-01  -1.93414217536274E-01   0.00000000000000E+00  -1.04769512996080E-15
     -9.54978544666229E-23  -4.05124335729126E-09  -4.05124440498649E-09  -3.12974922928586E-18
      5.04128080169141E-07
      0.00000000000000E+00  -4.03115736077556E-12   0.00000000000000E+00  -2.00511106294075E-16   1.23225199519100E-22
      4.03114761917838E-09   4.03114741866740E-09  -8.97777354192341E-19  -1.95299704112224E-01  -1.95299704112224E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98245558844074E-13   0.00000000000000E+00   3.98245558844074E-13
      4.02901112250758E-18  -1.94792770827807E-01  -1.93522613353867E-01   0.00000000000000E+00  -1.16503543670090E-15
     -9.55273082892650E-23  -4.03154449919071E-09  -4.03154566422624E-09  -3.13123376831524E-18
      5.09128080169141E-07
      0.00000000000000E+00  -4.00507345540862E-12   0.00000000000000E+00  -2.63256935659612E-16   1.22955847291354E-22
      4.00512465132811E-09   4.00512438807130E-09  -8.98467596156196E-19  -1.94934037065566E-01  -1.94934037065566E-01
      0.00000000000000E+00   0.00000000000000E+00   5.87408363801135E-13   0.00000000000000E+00   5.87408363801135E-13
      4.03194816432659E-18  -1.95012174219498E-01  -1.93750155952191E-01   0.00000000000000E+00  -1.95342109201710E-15
     -9.55755594788427E-23  -4.00570984301391E-09  -4.00571179643510E-09  -3.13348056817039E-18
      5.14128080169141E-07
      0.00000000000000E+00  -3.97384624475806E-12   0.00000000000000E+00   1.09593925550221E-15   1.22687504650265E-22
      3.97386077320811E-09   3.97386186914749E-09  -8.99326922931719E-19  -1.94473032095289E-01  -1.94473032095290E-01
      0.00000000000000E+00   0.00000000000000E+00   7.77206295661603E-13   0.00000000000000E+00   7.77206295661603E-13
      4.03583419580489E-18  -1.95367955151597E-01  -1.94115727110725E-01   0.00000000000000E+00  -4.25953206378676E-15
     -9.56440198407779E-23  -3.97463481591100E-09  -3.97463907544316E-09  -3.13650727287318E-18
      5.19128080169141E-07
      0.00000000000000E+00  -3.93931262356803E-12   0.00000000000000E+00   8.19073113417080E-15   1.22455374714234E-22
      3.93931486142707E-09   3.93932305215833E-09  -9.00312147055040E-19  -1.93938010350637E-01  -1.93938010350638E-01
      0.00000000000000E+00   0.00000000000000E+00   9.42609729151615E-13   0.00000000000000E+00   9.42609729151615E-13
      4.04054724445065E-18  -1.95869219513491E-01  -1.94627823443829E-01   0.00000000000000E+00  -1.24324842312462E-14
     -9.57319680116166E-23  -3.94025322940315E-09  -3.94026566188748E-09  -3.14023509739561E-18
      5.24128080169141E-07
      0.00000000000000E+00  -3.90468715764079E-12   0.00000000000000E+00  -1.07401159875642E-16   1.22306030986763E-22
      3.90466954462041E-09   3.90466943721937E-09  -9.01344846172101E-19  -1.93369179375050E-01  -1.93369179375052E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05170205983020E-12   0.00000000000000E+00   1.05170205983020E-12
      4.04580575474980E-18  -1.96509744966895E-01  -1.95279229957297E-01   0.00000000000000E+00  -4.66126970998556E-15
     -9.58360675689736E-23  -3.90571647800940E-09  -3.90572113927921E-09  -3.14446090857770E-18
      5.29128080169141E-07
      0.00000000000000E+00  -3.87437839436231E-12   0.00000000000000E+00   3.81180155893219E-16   1.22294186728623E-22
      3.87432347315113E-09   3.87432385433141E-09  -9.02307044136843E-19  -1.92828190042960E-01  -1.92828190042961E-01
      0.00000000000000E+00   0.00000000000000E+00   1.06670516073824E-12   0.00000000000000E+00   1.06670516073824E-12
      4.05113928055349E-18  -1.97262994454091E-01  -1.96042035654222E-01   0.00000000000000E+00  -5.69991784898661E-15
     -9.59489157638880E-23  -3.87538485957420E-09  -3.87539055949215E-09  -3.14883223641665E-18
      5.34128080169141E-07
      0.00000000000000E+00  -3.85389701796503E-12   0.00000000000000E+00   1.69718933562053E-15   1.22481516938359E-22
      3.85391198155237E-09   3.85391367874183E-09  -9.03040781741924E-19  -1.92398595645550E-01  -1.92398595645551E-01
      0.00000000000000E+00   0.00000000000000E+00   9.47639585809143E-13   0.00000000000000E+00   9.47639585809143E-13
      4.05587747848254E-18  -1.98077257618520E-01  -1.96862767304012E-01   0.00000000000000E+00  -6.73683524577659E-15
     -9.60594948724778E-23  -3.85485458149230E-09  -3.85486131832764E-09  -3.15283669674062E-18
      5.39128080169140E-07
      0.00000000000000E+00  -3.85013138373952E-12   0.00000000000000E+00   2.28960701321001E-14   1.22928193184635E-22
      3.85004191495875E-09   3.85006481102901E-09  -9.03353605773395E-19  -1.92183401285764E-01  -1.92183401285765E-01
      0.00000000000000E+00   0.00000000000000E+00   6.55848696062289E-13   0.00000000000000E+00   6.55848696062289E-13
      4.05915672196285E-18  -1.98872257655125E-01  -1.97659078726675E-01   0.00000000000000E+00  -2.72844219122656E-14
     -9.61522243769569E-23  -3.85069337530306E-09  -3.85072065972507E-09  -3.15580311618945E-18
      5.44128080169140E-07
      0.00000000000000E+00  -3.86996984697635E-12   0.00000000000000E+00   1.64446489343751E-14   1.23682577179457E-22
      3.86996784691066E-09   3.86998429155972E-09  -9.03032820879552E-19  -1.92298128231419E-01  -1.92298128231419E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60586562979766E-13   0.00000000000000E+00   1.60586562979766E-13
      4.05995965477775E-18  -1.99537426486147E-01  -1.98318125900785E-01   0.00000000000000E+00  -1.89969647514240E-14
     -9.62076489659257E-23  -3.87012588115785E-09  -3.87014487812270E-09  -3.15692683389820E-18
      5.49128080169140E-07
      0.00000000000000E+00  -3.92103552086373E-12   0.00000000000000E+00   1.45791051380712E-13   1.24768374895950E-22
      3.92100973202967E-09   3.92115552308117E-09  -9.01865676146994E-19  -1.92860650604409E-01  -1.92860650604409E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.55534506013987E-13   0.00000000000000E+00  -5.55534506013987E-13
      4.05718198224768E-18  -1.99932978504617E-01  -1.98697822428997E-01   0.00000000000000E+00  -1.46670520207680E-13
     -9.62034931312463E-23  -3.92045331805486E-09  -3.92059998857516E-09  -3.15531630610068E-18
      5.54128080169140E-07
      0.00000000000000E+00  -4.00994122648062E-12   0.00000000000000E+00   4.72118367490323E-14   1.26165239002319E-22
      4.00994407653853E-09   4.00999128837540E-09  -8.99674536168444E-19  -1.93973716809725E-01  -1.93973716809724E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48747998834602E-12   0.00000000000000E+00  -1.48747998834602E-12
      4.04974458230595E-18  -1.99893765190641E-01  -1.98630883247810E-01   0.00000000000000E+00  -4.35158722058446E-14
     -9.61165845035007E-23  -4.00846029251475E-09  -4.00850380838706E-09  -3.15007004613751E-18
      5.59128080169140E-07
      0.00000000000000E+00  -4.14164657963621E-12   0.00000000000000E+00   1.32857365343377E-15   1.27794383093469E-22
      4.14163030113610E-09   4.14163162970988E-09  -8.96347778928533E-19  -1.95708337610888E-01  -1.95708337610885E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.60382070357262E-12   0.00000000000000E+00  -2.60382070357262E-12
      4.03672547878809E-18  -1.99239406815153E-01  -1.97935387612851E-01   0.00000000000000E+00   7.73979021035113E-15
     -9.59246174264834E-23  -4.13903554879642E-09  -4.13902780900630E-09  -3.14037769985956E-18
      5.64128080169140E-07
      0.00000000000000E+00  -4.31780478560025E-12   0.00000000000000E+00   6.67323926704527E-14   1.29504075970418E-22
      4.31776513549283E-09   4.31783186788563E-09  -8.91880459624039E-19  -1.98082255223394E-01  -1.98082255223390E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.83961194239291E-12   0.00000000000000E+00  -3.83961194239291E-12
      4.01752741907612E-18  -1.97789773781275E-01  -1.96430650810330E-01   0.00000000000000E+00  -5.33994176737659E-14
     -9.56090810347360E-23  -4.31393885652547E-09  -4.31399225594324E-09  -3.12564695945209E-18
      5.69128080169140E-07
      0.00000000000000E+00  -4.53501758909605E-12   0.00000000000000E+00   2.19148515611679E-15   1.31073970214392E-22
      4.53506554386085E-09   4.53506773534614E-09  -8.86407171126189E-19  -2.01040570921952E-01  -2.01040570921947E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.09064382637024E-12   0.00000000000000E+00  -5.09064382637024E-12
      3.99207419994427E-18  -1.95388278943666E-01  -1.93961087189457E-01   0.00000000000000E+00   1.81322771645159E-14
     -9.51618924045076E-23  -4.52999522379684E-09  -4.52997709151977E-09  -3.10566702881808E-18
      5.74128080169140E-07
      0.00000000000000E+00  -4.78235546639592E-12   0.00000000000000E+00   3.55305979172381E-14   1.32215814975040E-22
      4.78238326099052E-09   4.78241879158857E-09  -8.80224678436281E-19  -2.04440780869466E-01  -2.04440780869460E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.21470441167559E-12   0.00000000000000E+00  -6.21470441167559E-12
      3.96100067788590E-18  -1.91937699724571E-01  -1.90432941604011E-01   0.00000000000000E+00  -1.16281742077793E-14
     -9.45849445628581E-23  -4.77619245900260E-09  -4.77620408717690E-09  -3.08077599944961E-18
      5.79128080169140E-07
      0.00000000000000E+00  -5.03896966215375E-12   0.00000000000000E+00   2.60157787651947E-15   1.32622193792257E-22
      5.03894546526743E-09   5.03894806684544E-09  -8.73805937527026E-19  -2.08040966853224E-01  -2.08040966853217E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.02441784781885E-12   0.00000000000000E+00  -7.02441784781885E-12
      3.92587858864680E-18  -1.87442606600649E-01  -1.85857270145404E-01   0.00000000000000E+00   2.70394969407746E-14
     -9.39020915844285E-23  -5.03195068849447E-09  -5.03192364899763E-09  -3.05207265111977E-18
      5.84128080169140E-07
      0.00000000000000E+00  -5.27161238150041E-12   0.00000000000000E+00   2.34704627236276E-15   1.31991562606779E-22
      5.27161782149388E-09   5.27162016854028E-09  -8.67809781003108E-19  -2.11491299587334E-01  -2.11491299587327E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29179321464860E-12   0.00000000000000E+00  -7.29179321464860E-12
      3.88941962257356E-18  -1.82062784728724E-01  -1.80404225454195E-01   0.00000000000000E+00   2.91934751655506E-14
     -9.31572282898248E-23  -5.26435756880071E-09  -5.26432837532564E-09  -3.02160984157045E-18
      5.89128080169140E-07
      0.00000000000000E+00  -5.43500416899260E-12   0.00000000000000E+00   1.65228084652299E-15   1.30096710812131E-22
      5.43498427629738E-09   5.43498592857836E-09  -8.63090593118950E-19  -2.14325741417997E-01  -2.14325741417990E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74304791517644E-12   0.00000000000000E+00  -6.74304791517644E-12
      3.85570438299767E-18  -1.76163833261459E-01  -1.74453629343893E-01   0.00000000000000E+00   2.87673686553400E-14
     -9.24230518471066E-23  -5.42827164803174E-09  -5.42824288066318E-09  -2.99261378987872E-18
      5.94128080169140E-07
      0.00000000000000E+00  -5.47357895861976E-12   0.00000000000000E+00   4.02535410518909E-16   1.26819039733016E-22
      5.47361198847434E-09   5.47361239100988E-09  -8.60713659402367E-19  -2.15953345153043E-01  -2.15953345153038E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.07180437644337E-12   0.00000000000000E+00  -5.07180437644337E-12
      3.83034536111546E-18  -1.70354801581538E-01  -1.68631899609883E-01   0.00000000000000E+00   2.50330580751089E-14
     -9.17978796562093E-23  -5.46856561969142E-09  -5.46854058663344E-09  -2.96963170171309E-18
      5.99128080169140E-07
      0.00000000000000E+00  -5.32956641067836E-12   0.00000000000000E+00  -1.43548591785583E-15   1.22141870475565E-22
      5.32960903113996E-09   5.32960759565416E-09  -8.61964798357073E-19  -2.15655183369935E-01  -2.15655183369933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97397098216966E-12   0.00000000000000E+00  -1.97397098216966E-12
      3.82047550620461E-18  -1.65488467066566E-01  -1.63809957605810E-01   0.00000000000000E+00   1.72272364639936E-14
     -9.14009911404218E-23  -5.32765085190836E-09  -5.32763362467199E-09  -2.95851070784754E-18
      6.04128080169140E-07
      0.00000000000000E+00  -4.95722784603905E-12   0.00000000000000E+00  -3.72726062082812E-15   1.16059968912505E-22
      4.95722023001379E-09   4.95721650275329E-09  -8.68325664370278E-19  -2.12604141540047E-01  -2.12604141540050E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76802146048657E-12   0.00000000000000E+00   2.76802146048657E-12
      3.83431561350704E-18  -1.62592771964444E-01  -1.61030092948372E-01   0.00000000000000E+00   4.45391505812631E-15
     -9.13661500814853E-23  -4.95998897812873E-09  -4.95998452421376E-09  -2.96598994913676E-18
      6.09128080169140E-07
      0.00000000000000E+00  -4.34416422517881E-12   0.00000000000000E+00  -3.54682631959624E-15   1.08404934608777E-22
      4.34410988931708E-09   4.34410634249087E-09  -8.81377151229797E-19  -2.05933307116189E-01  -2.05933307116199E-01
      0.00000000000000E+00   0.00000000000000E+00   9.13895043984555E-12   0.00000000000000E+00   9.13895043984555E-12
      3.88001036570627E-18  -1.62705157138161E-01  -1.61333637793550E-01   0.00000000000000E+00  -1.70026373878530E-14
     -9.18377436455080E-23  -4.35322829029324E-09  -4.35324529293072E-09  -2.99863321447648E-18
      6.14128080169140E-07
      0.00000000000000E+00  -3.53225674826427E-12   0.00000000000000E+00  -1.07828144231385E-14   9.86806602993071E-23
      3.53222298340752E-09   3.53221220059319E-09  -9.02617732376378E-19  -1.94871865635851E-01  -1.94871865635868E-01
      0.00000000000000E+00   0.00000000000000E+00   1.67090110750349E-11   0.00000000000000E+00   1.67090110750349E-11
      3.96355542108144E-18  -1.66616570680498E-01  -1.65498460024757E-01   0.00000000000000E+00  -3.80199599287800E-14
     -9.29671302958329E-23  -3.54888319170821E-09  -3.54892121166823E-09  -3.06093768870507E-18
      6.19128080169140E-07
      0.00000000000000E+00  -2.62326938412138E-12   0.00000000000000E+00  -9.24901263635491E-15   8.61389470477823E-23
      2.62332386865279E-09   2.62331461964024E-09  -9.33236884237827E-19  -1.78936858795315E-01  -1.78936858795339E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45242124993404E-11   0.00000000000000E+00   2.45242124993404E-11
      4.08617648357814E-18  -1.74601981691939E-01  -1.73767766625663E-01   0.00000000000000E+00  -7.56957229855544E-14
     -9.48907422105474E-23  -2.64776313641649E-09  -2.64783883213957E-09  -3.15293959934032E-18
      6.24128080169140E-07
      0.00000000000000E+00  -1.75533661751025E-12   0.00000000000000E+00  -8.70395032189776E-15   7.03263283555607E-23
      1.75530336404965E-09   1.75529466009940E-09  -9.73894607917978E-19  -1.58128353182842E-01  -1.58128353182873E-01
      0.00000000000000E+00   0.00000000000000E+00   3.12555594674716E-11   0.00000000000000E+00   3.12555594674716E-11
      4.24245428091551E-18  -1.86275787419455E-01  -1.85712928941521E-01   0.00000000000000E+00  -1.20723511833290E-13
     -9.76559141474761E-23  -1.78642949605494E-09  -1.78655021956687E-09  -3.26855967299753E-18
      6.29128080169140E-07
      0.00000000000000E+00  -1.05217330944943E-12   0.00000000000000E+00   5.11487811541529E-15   5.19785306286950E-23
      1.05217670618465E-09   1.05218182106282E-09  -1.02438115156120E-18  -1.33087510819876E-01  -1.33087510819912E-01
      0.00000000000000E+00   0.00000000000000E+00   3.56960000576724E-11   0.00000000000000E+00   3.56960000576724E-11
      4.42093428120387E-18  -2.00689355941976E-01  -2.00346622988138E-01   0.00000000000000E+00  -1.85435972730740E-13
     -1.01125016546834E-22  -1.08769238514766E-09  -1.08787782112049E-09  -3.39655312964267E-18
      6.34128080169140E-07
      0.00000000000000E+00  -5.74213297021457E-13   0.00000000000000E+00  -5.32272556540127E-15   3.36002857495170E-23
      5.74203197977317E-10   5.74197875251785E-10  -1.08265702829953E-18  -1.05320226650886E-01  -1.05320226650923E-01
      0.00000000000000E+00   0.00000000000000E+00   3.71889746762943E-11   0.00000000000000E+00   3.71889746762943E-11
      4.60687915458534E-18  -2.16658211658955E-01  -2.16465595423970E-01   0.00000000000000E+00  -2.23870424785644E-13
     -1.04997084025329E-22  -6.11162979503189E-10  -6.11386849928080E-10  -3.52422212628581E-18
      6.39128080169140E-07
      0.00000000000000E+00  -3.04006080156914E-13   0.00000000000000E+00  -3.41932721777928E-15   1.92766261782670E-23
      3.04015325960435E-10   3.04011906633236E-10  -1.14284101579304E-18  -7.77145127848384E-02  -7.77145127848737E-02
      0.00000000000000E+00   0.00000000000000E+00   3.53142687588507E-11   0.00000000000000E+00   3.53142687588507E-11
      4.78345049837959E-18  -2.33139823393387E-01  -2.33032920326152E-01   0.00000000000000E+00  -2.55521238267906E-13
     -1.08884970602139E-22  -3.39070654153710E-10  -3.39326175392087E-10  -3.64060948258656E-18
      6.44128080169139E-07
      0.00000000000000E+00  -1.78454324394224E-13   0.00000000000000E+00  -1.82592351832705E-15   1.36689441748441E-23
      1.78450664793812E-10   1.78448838870307E-10  -1.19437348559004E-18  -5.47368501527601E-02  -5.47368501527897E-02
      0.00000000000000E+00   0.00000000000000E+00   2.95711640373414E-11   0.00000000000000E+00   2.95711640373414E-11
      4.93130631856630E-18  -2.49443731055909E-01  -2.49378195946450E-01   0.00000000000000E+00  -2.48017823891067E-13
     -1.12344492160589E-22  -2.07771985083646E-10  -2.08020002907649E-10  -3.73693283297626E-18
      6.49128080169139E-07
      0.00000000000000E+00  -1.31521663681178E-13   0.00000000000000E+00  -8.42915028614657E-16   1.92788289251213E-23
      1.31502747980785E-10   1.31501905065775E-10  -1.22849595759953E-18  -3.98250972878831E-02  -3.98250972879043E-02
      0.00000000000000E+00   0.00000000000000E+00   2.12371478490142E-11   0.00000000000000E+00   2.12371478490142E-11
      5.03749205781137E-18  -2.65220575631243E-01  -2.65172456743204E-01   0.00000000000000E+00  -2.03637910918181E-13
     -1.15040453617124E-22  -1.52535415003757E-10  -1.52739052914790E-10  -3.80899610021184E-18
      6.54128080169139E-07
      0.00000000000000E+00  -1.21326897851143E-13   0.00000000000000E+00  -2.57030498185256E-16   3.49351253655544E-23
      1.21334322509518E-10   1.21334065479054E-10  -1.24442197426574E-18  -3.29093930967600E-02  -3.29093930967732E-02
      0.00000000000000E+00   0.00000000000000E+00   1.32245915244995E-11   0.00000000000000E+00   1.32245915244995E-11
      5.10361501543387E-18  -2.80322979214953E-01  -2.80280588184440E-01   0.00000000000000E+00  -1.50373312474764E-13
     -1.16967131212238E-22  -1.34408283690962E-10  -1.34558657003554E-10  -3.85919304116813E-18
      6.59128080169139E-07
      0.00000000000000E+00  -1.31705353155593E-13   0.00000000000000E+00   1.38076900715624E-16   5.73173543424465E-23
      1.31712453472133E-10   1.31712591549091E-10  -1.24505020469309E-18  -3.24427776232863E-02  -3.24427776232930E-02
      0.00000000000000E+00   0.00000000000000E+00   6.68309061166416E-12   0.00000000000000E+00   6.68309061166416E-12
      5.13703046849219E-18  -2.94686940544580E-01  -2.94643340977593E-01   0.00000000000000E+00  -1.03571709189093E-13
     -1.18262653590667E-22  -1.38292110451448E-10  -1.38395682160755E-10  -3.89198026379910E-18
      6.64128080169139E-07
      0.00000000000000E+00  -1.63667321703813E-13   0.00000000000000E+00   5.13295771500751E-16   8.30071487716344E-23
      1.63707333868953E-10   1.63707847164807E-10  -1.23165047013114E-18  -3.77407473793241E-02  -3.77407473793249E-02
      0.00000000000000E+00   0.00000000000000E+00   8.12260389359765E-13   0.00000000000000E+00   8.12260389359765E-13
      5.14109177043899E-18  -3.08271737440057E-01  -3.08219907979253E-01   0.00000000000000E+00  -5.92074634606866E-14
     -1.18984430639314E-22  -1.64460900090587E-10  -1.64520107554166E-10  -3.90944130030785E-18
      6.69128080169139E-07
      0.00000000000000E+00  -2.33469321981533E-13   0.00000000000000E+00   1.04447055010338E-15   1.09443813821651E-22
      2.33450587393761E-10   2.33451631864421E-10  -1.20346185049122E-18  -4.90540509845146E-02  -4.90540509845092E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.39409605758368E-12   0.00000000000000E+00  -5.39409605758368E-12
      5.11412129015107E-18  -3.20952506707313E-01  -3.20880660931549E-01   0.00000000000000E+00  -1.14055274632828E-14
     -1.19103621070782E-22  -2.28046130279255E-10  -2.28057535806838E-10  -3.91065943965985E-18
      6.74128080169139E-07
      0.00000000000000E+00  -3.75369440967162E-13   0.00000000000000E+00   1.88222998106638E-15   1.33781562337392E-22
      3.75409513964743E-10   3.75411396194858E-10  -1.16140420621222E-18  -6.60318365292444E-02  -6.60318365292327E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.17516593055105E-11   0.00000000000000E+00  -1.17516593055105E-11
      5.05536299362352E-18  -3.32416737097959E-01  -3.32302171996961E-01   0.00000000000000E+00   3.42064347380162E-14
     -1.18651777334358E-22  -3.63693943323966E-10  -3.63659736889347E-10  -3.89395878741130E-18
      6.79128080169139E-07
      0.00000000000000E+00  -6.44382676248008E-13   0.00000000000000E+00   3.18766082172405E-15   1.53503282662940E-22
      6.44416352401831E-10   6.44419540062806E-10  -1.11074961790800E-18  -8.68363000265429E-02  -8.68363000265257E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.71964670931217E-11   0.00000000000000E+00  -1.71964670931217E-11
      4.96938065815791E-18  -3.42102241630349E-01  -3.41904644614336E-01   0.00000000000000E+00   6.67999087896811E-14
     -1.17784290218328E-22  -6.27289872878356E-10  -6.27223072969684E-10  -3.85863104024991E-18
      6.84128080169139E-07
      0.00000000000000E+00  -1.10930073599251E-12   0.00000000000000E+00   5.10627155077298E-15   1.68508758222544E-22
      1.10933759763031E-09   1.10934270390203E-09  -1.05835851630771E-18  -1.09233527078740E-01  -1.09233527078718E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13999297154267E-11   0.00000000000000E+00  -2.13999297154267E-11
      4.86238100958078E-18  -3.49153687304033E-01  -3.48810946236459E-01   0.00000000000000E+00   8.63494082434704E-14
     -1.16649207072916E-22  -1.08802912359473E-09  -1.08794277418661E-09  -3.80402249327306E-18
      6.89128080169139E-07
      0.00000000000000E+00  -1.83285357571340E-12   0.00000000000000E+00   7.60883824495845E-15   1.79790693529550E-22
      1.83286740145174E-09   1.83287501029016E-09  -1.00898904880177E-18  -1.31653033628143E-01  -1.31653033628119E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.48284458640704E-11   0.00000000000000E+00  -2.48284458640704E-11
      4.73823878026042E-18  -3.52466191479650E-01  -3.51896589148350E-01   0.00000000000000E+00   1.00919536675367E-13
     -1.15292494010799E-22  -1.80814748396265E-09  -1.80804656442609E-09  -3.72924973145866E-18
      6.94128080169139E-07
      0.00000000000000E+00  -2.85205462450533E-12   0.00000000000000E+00   1.04902306024868E-14   1.87967433132316E-22
      2.85199861968695E-09   2.85200910991774E-09  -9.64325238914211E-19  -1.53361025174685E-01  -1.53361025174657E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.79669400435219E-11   0.00000000000000E+00  -2.79669400435219E-11
      4.59840408004281E-18  -3.50816121546491E-01  -3.49926437651730E-01   0.00000000000000E+00   1.18490945127667E-13
     -1.13657918191149E-22  -2.82416066081923E-09  -2.82404216987421E-09  -3.63407884112860E-18
      6.99128080169139E-07
      0.00000000000000E+00  -4.17370039292164E-12   0.00000000000000E+00   1.34012198503681E-14   1.93164666058965E-22
      4.17367718872801E-09   4.17369058994805E-09  -9.24147859790348E-19  -1.74143748743422E-01  -1.74143748743391E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.09351264280610E-11   0.00000000000000E+00  -3.09351264280610E-11
      4.44372844790251E-18  -3.43005954958134E-01  -3.41700815991949E-01   0.00000000000000E+00   1.43398500538422E-13
     -1.11623189641098E-22  -4.14289886202042E-09  -4.14275546351999E-09  -3.51958058811216E-18
      7.04128080169139E-07
      0.00000000000000E+00  -5.77786057298830E-12   0.00000000000000E+00   1.61447677735593E-14   1.95294987901287E-22
      5.77782396376114E-09   5.77784010852911E-09  -8.87692833559096E-19  -1.93963149457370E-01  -1.93963149457336E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35704326067873E-11   0.00000000000000E+00  -3.35704326067873E-11
      4.27587628486857E-18  -3.27989892641833E-01  -3.26180195801730E-01   0.00000000000000E+00   1.75407266050506E-13
     -1.09038907149837E-22  -5.74444508318826E-09  -5.74426967592232E-09  -3.38818345130948E-18
      7.09128080169139E-07
      0.00000000000000E+00  -7.62302134348751E-12   0.00000000000000E+00   1.84781000696338E-14   1.94510020028341E-22
      7.62301699372461E-09   7.62303547182487E-09  -8.54204919511302E-19  -2.12836540191907E-01  -2.12836540191871E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.57508502902427E-11   0.00000000000000E+00  -3.57508502902427E-11
      4.09712203341736E-18  -3.04970438675374E-01  -3.02580087679757E-01   0.00000000000000E+00   2.10350917554249E-13
     -1.05745064182336E-22  -7.58749497245208E-09  -7.58728462153463E-09  -3.24291711390606E-18
      7.14128080169139E-07
      0.00000000000000E+00  -9.63974808309038E-12   0.00000000000000E+00   2.01528422233061E-14   1.91121880705642E-22
      9.63975577870614E-09   9.63977593154856E-09  -8.23103594072356E-19  -2.30799538262902E-01  -2.30799538262865E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.75718701214153E-11   0.00000000000000E+00  -3.75718701214153E-11
      3.90926268281028E-18  -2.73523272304526E-01  -2.70498092409704E-01   0.00000000000000E+00   2.38791816802222E-13
     -1.01571186419518E-22  -9.60244285324384E-09  -9.60220406142714E-09  -3.08615908873792E-18
      7.19128080169139E-07
      0.00000000000000E+00  -1.16933964070507E-11   0.00000000000000E+00   2.04940241252537E-14   1.84192822475064E-22
      1.16933877933080E-08   1.16934082873323E-08  -7.94055300566077E-19  -2.47890652282788E-01  -2.47890652282749E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.95029482747336E-11   0.00000000000000E+00  -3.95029482747336E-11
      3.71174794143661E-18  -2.33881653532332E-01  -2.30210039323709E-01   0.00000000000000E+00   2.46135408143251E-13
     -9.64092723368807E-23  -1.16541514744656E-08  -1.16539053390575E-08  -2.91769264087054E-18
      7.24128080169139E-07
      0.00000000000000E+00  -1.35414962091405E-11   0.00000000000000E+00   1.84455360698058E-14   1.68949526201495E-22
      1.35414928256232E-08   1.35415112711594E-08  -7.66984317883831E-19  -2.64145366886174E-01  -2.64145366886132E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.22689913572866E-11   0.00000000000000E+00  -4.22689913572866E-11
      3.50040298465018E-18  -1.87396766326488E-01  -1.83143723282426E-01   0.00000000000000E+00   2.21501124035578E-13
     -9.06335661685315E-23  -1.34994637809260E-08  -1.34992422798021E-08  -2.73341866676635E-18
      7.29128080169139E-07
      0.00000000000000E+00  -1.49484657384226E-11   0.00000000000000E+00   1.50299313282154E-14   1.40938479876955E-22
      1.49484648859473E-08   1.49484799158787E-08  -7.41756092724372E-19  -2.79601510757091E-01  -2.79601510757045E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.51878160078748E-11   0.00000000000000E+00  -4.51878160078748E-11
      3.27446390461081E-18  -1.36452083969691E-01  -1.31756641830652E-01   0.00000000000000E+00   1.79092440794618E-13
     -8.54651881597486E-23  -1.49034711923116E-08  -1.49032920998709E-08  -2.53270781188643E-18
      7.34128080169139E-07
      0.00000000000000E+00  -1.55664889750921E-11   0.00000000000000E+00   8.87101288774114E-14   1.00282425211103E-22
      1.55664756114796E-08   1.55665643216085E-08  -7.18138642289208E-19  -2.94302486184332E-01  -2.94302486184286E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.67668318220487E-11   0.00000000000000E+00  -4.67668318220487E-11
      3.04062974550056E-18  -8.49671984239586E-02  -8.00775101172524E-02   0.00000000000000E+00   6.13901789555320E-14
     -7.70841240324075E-23  -1.55198588799654E-08  -1.55197974897865E-08  -2.32249110321135E-18
      7.39128080169139E-07
      0.00000000000000E+00  -1.39164064264217E-11   0.00000000000000E+00  -1.61421798194734E-14   5.26907290253633E-23
      1.39164030911153E-08   1.39163869489355E-08  -6.95145198889381E-19  -3.08305148089130E-01  -3.08305148089086E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.37403220102563E-11   0.00000000000000E+00  -4.37403220102563E-11
      2.82192813544928E-18  -4.36966921000675E-02  -3.93259119562573E-02   0.00000000000000E+00   1.15954866647940E-13
     -4.98810218261196E-23  -1.38727625817919E-08  -1.38726466269253E-08  -2.12678293655990E-18
      7.44128080169139E-07
      0.00000000000000E+00  -1.02599755934528E-11   0.00000000000000E+00  -3.59176774609838E-14   2.41219881369098E-23
      1.02599924924668E-08   1.02599565747894E-08  -6.69849841829328E-19  -3.21680656268545E-01  -3.21680656268512E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.24628712282931E-11   0.00000000000000E+00  -3.24628712282931E-11
      2.65961377930782E-18  -2.16460209416983E-02  -1.84236905457906E-02   0.00000000000000E+00   8.86754142012037E-14
     -2.39775031224229E-23  -1.02275823789753E-08  -1.02274937035611E-08  -1.98976393747849E-18
      7.49128080169138E-07
      0.00000000000000E+00  -7.72432608862742E-12   0.00000000000000E+00  -2.48496490387412E-14   1.25022587320800E-23
      7.72436301822803E-09   7.72433816857901E-09  -6.42570170444263E-19  -3.34447844033484E-01  -3.34447844033461E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.30573496131564E-11   0.00000000000000E+00  -2.30573496131564E-11
      2.54432703124203E-18  -1.26062589882715E-02  -1.01798472868747E-02   0.00000000000000E+00   5.38286374836122E-14
     -1.35428917006414E-23  -7.70133464760332E-09  -7.70128081896585E-09  -1.90175686079777E-18
      7.54128080169138E-07
      0.00000000000000E+00  -6.66177432387354E-12   0.00000000000000E+00  -1.03273494736981E-14   8.19446232475527E-24
      6.66182635240713E-09   6.66181602505766E-09  -6.14901546308186E-19  -3.46608017418621E-01  -3.46608017418603E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85742602708610E-11   0.00000000000000E+00  -1.85742602708610E-11
      2.45145572988773E-18  -9.00217785177245E-03  -6.90911599790735E-03   0.00000000000000E+00   3.00720048399396E-14
     -9.14009788629815E-24  -6.64327183679164E-09  -6.64324176478681E-09  -1.83655418357954E-18
      7.59128080169138E-07
      0.00000000000000E+00  -6.29292585924811E-12   0.00000000000000E+00  -3.49951760341529E-15   6.08744542835088E-24
      6.29292298048098E-09   6.29291948096339E-09  -5.87681399500296E-19  -3.58168074641860E-01  -3.58168074641844E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.65928559264193E-11   0.00000000000000E+00  -1.65928559264193E-11
      2.36849145025563E-18  -7.30213160479577E-03  -5.32467062348840E-03   0.00000000000000E+00   1.93325082909483E-14
     -7.14888649656009E-24  -6.27634595754525E-09  -6.27632662503696E-09  -1.78081005075534E-18
      7.64128080169138E-07
      0.00000000000000E+00  -6.16094497188089E-12   0.00000000000000E+00  -1.17635696724823E-15   4.85015620238760E-24
      6.16092584046224E-09   6.16092466410528E-09  -5.61306574895781E-19  -3.69125307515385E-01  -3.69125307515369E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55069104084071E-11   0.00000000000000E+00  -1.55069104084071E-11
      2.29095689821360E-18  -6.29922914914037E-03  -4.36301171689414E-03   0.00000000000000E+00   1.47564818196331E-14
     -5.90514773593748E-24  -6.14543251017869E-09  -6.14541775369687E-09  -1.72965032331781E-18
      7.69128080169138E-07
      0.00000000000000E+00  -6.10188880585645E-12   0.00000000000000E+00  -4.69677929749163E-16   4.02093536989944E-24
      6.10189694862907E-09   6.10189647895115E-09  -5.36122318749233E-19  -3.79431645504405E-01  -3.79431645504391E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46650336788842E-11   0.00000000000000E+00  -1.46650336788842E-11
      2.21763172981917E-18  -5.61706759616830E-03  -3.69918147090288E-03   0.00000000000000E+00   1.23125724914279E-14
     -5.02534272181063E-24  -6.08724375784475E-09  -6.08723144527226E-09  -1.68150941106994E-18
      7.74128080169138E-07
      0.00000000000000E+00  -6.06680411624318E-12   0.00000000000000E+00  -2.46679223241417E-16   3.43552936044222E-24
      6.06680099421227E-09   6.06680074753305E-09  -5.12696619091085E-19  -3.88923567742723E-01  -3.88923567742710E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36977294303379E-11   0.00000000000000E+00  -1.36977294303379E-11
      2.14914308266749E-18  -5.12714503068407E-03  -3.22001055788849E-03   0.00000000000000E+00   1.04642890925323E-14
     -4.38066316500339E-24  -6.05311348239180E-09  -6.05310301810271E-09  -1.63644646357640E-18
      7.79128080169138E-07
      0.00000000000000E+00  -6.04062836613903E-12   0.00000000000000E+00  -1.50151465122759E-16   3.01976638347565E-24
      6.04063527620447E-09   6.04063512605301E-09  -4.92052253215455E-19  -3.97239299548550E-01  -3.97239299548537E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22129300177249E-11   0.00000000000000E+00  -1.22129300177249E-11
      2.08807843257886E-18  -4.77593613438163E-03  -2.87657688864664E-03   0.00000000000000E+00   8.60213268881865E-15
     -3.91927578611000E-24  -6.02843079816797E-09  -6.02842219603529E-09  -1.59602617936341E-18
      7.84128080169138E-07
      0.00000000000000E+00  -6.01748349236274E-12   0.00000000000000E+00  -9.58834817967096E-17   2.73555450912885E-24
      6.01744146405410E-09   6.01744136817063E-09  -4.75802128798853E-19  -4.03766036064025E-01  -4.03766036064015E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.75218778584563E-12   0.00000000000000E+00  -9.75218778584563E-12
      2.03931749364963E-18  -4.53834899871073E-03  -2.64552139228392E-03   0.00000000000000E+00   6.41802575328939E-15
     -3.62037233741323E-24  -6.00769559841052E-09  -6.00768918038478E-09  -1.56351536485078E-18
      7.89128080169138E-07
      0.00000000000000E+00  -5.99351201595157E-12   0.00000000000000E+00  -1.99621647958007E-16   2.56473586652369E-24
      5.99352784651297E-09   5.99352764689132E-09  -4.66185322375752E-19  -4.07624591333576E-01  -4.07624591333570E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.84446657124936E-12   0.00000000000000E+00  -5.84446657124936E-12
      2.01009516079339E-18  -4.40567382895417E-03  -2.51914905289211E-03   0.00000000000000E+00   3.79763976796032E-15
     -3.48549330706396E-24  -5.98768697795983E-09  -5.98768318032007E-09  -1.54390983841763E-18
      7.94128080169138E-07
      0.00000000000000E+00  -5.96522383689165E-12   0.00000000000000E+00  -2.77846345213037E-16   2.50472899413809E-24
      5.96526402537443E-09   5.96526374752809E-09  -4.65972444873892E-19  -4.07709982264416E-01  -4.07709982264416E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41302233096139E-13   0.00000000000000E+00  -1.41302233096139E-13
      2.00938864962791E-18  -4.38518093121382E-03  -2.50576429734142E-03   0.00000000000000E+00   3.11282318102910E-16
     -3.54590080823463E-24  -5.96512275657731E-09  -5.96512244529499E-09  -1.54341620475401E-18
      7.99128080169138E-07
      0.00000000000000E+00  -5.92729196042495E-12   0.00000000000000E+00  -4.20487542391468E-16   2.57090894890626E-24
      5.92727454430735E-09   5.92727412381981E-09  -4.78213338576456E-19  -4.02798938615016E-01  -4.02798938615024E-01
      0.00000000000000E+00   0.00000000000000E+00   7.39975097607586E-12   0.00000000000000E+00   7.39975097607586E-12
      2.04638740450829E-18  -4.50903161532450E-03  -2.63920881572773E-03   0.00000000000000E+00  -4.26687731734216E-15
     -3.89053176664128E-24  -5.93466960791855E-09  -5.93467387479587E-09  -1.56817406593183E-18
      8.04128080169138E-07
      0.00000000000000E+00  -5.86869501808654E-12   0.00000000000000E+00  -6.86003869190477E-16   2.80644943852840E-24
      5.86866953580299E-09   5.86866884979912E-09  -5.05823449644113E-19  -3.91701476773816E-01  -3.91701476773832E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63978469124670E-11   0.00000000000000E+00   1.63978469124670E-11
      2.12837663907062E-18  -4.86123943523191E-03  -3.00704736942622E-03   0.00000000000000E+00  -1.03584474236087E-14
     -4.74576841754701E-24  -5.88505633826416E-09  -5.88506669671159E-09  -1.62255318942651E-18
      8.09128080169138E-07
      0.00000000000000E+00  -5.76243065713744E-12   0.00000000000000E+00  -1.24960177447122E-15   3.30245078161754E-24
      5.76244287304857E-09   5.76244162344680E-09  -5.50997357798507E-19  -3.73387986858234E-01  -3.73387986858260E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62083636693758E-11   0.00000000000000E+00   2.62083636693758E-11
      2.25941845741750E-18  -5.65298848476233E-03  -3.82917617045404E-03   0.00000000000000E+00  -1.86394578594625E-14
     -6.70848713360186E-24  -5.78863134765831E-09  -5.78864998711617E-09  -1.70842109961899E-18
      8.14128080169138E-07
      0.00000000000000E+00  -5.53603337992088E-12   0.00000000000000E+00  -3.75280248461627E-15   4.21966332392041E-24
      5.53609855783832E-09   5.53609480503584E-09  -6.14219854494722E-19  -3.47069481155065E-01  -3.47069481155101E-01
      0.00000000000000E+00   0.00000000000000E+00   3.65584218313255E-11   0.00000000000000E+00   3.65584218313255E-11
      2.44221056657413E-18  -7.43060384838180E-03  -5.67484775078081E-03   0.00000000000000E+00  -2.89774962294522E-14
     -1.13959867370507E-23  -5.57262424937092E-09  -5.57265322686716E-09  -1.82799071207941E-18
      8.19128080169138E-07
      0.00000000000000E+00  -5.00939565677292E-12   0.00000000000000E+00  -5.64600453192724E-15   5.70890465360623E-24
      5.00939318623546E-09   5.00938754023093E-09  -6.92948761079781E-19  -3.12273741253747E-01  -3.12273741253796E-01
      0.00000000000000E+00   0.00000000000000E+00   4.87103158326320E-11   0.00000000000000E+00   4.87103158326320E-11
      2.68576214573729E-18  -1.15633431252657E-02  -9.96971095599744E-03   0.00000000000000E+00  -4.63532846484999E-14
     -2.26453567016070E-23  -5.05805150277889E-09  -5.05809785606356E-09  -1.99281338465751E-18
      8.24128080169138E-07
      0.00000000000000E+00  -3.89008384442480E-12   0.00000000000000E+00  -1.14418520642888E-14   7.14561786924515E-24
      3.89010567404610E-09   3.89009423219405E-09  -7.82177338373377E-19  -2.69039091480947E-01  -2.69039091481012E-01
      0.00000000000000E+00   0.00000000000000E+00   6.48137398343509E-11   0.00000000000000E+00   6.48137398343509E-11
      3.00983084490904E-18  -2.07307891171815E-02  -1.94847392975430E-02   0.00000000000000E+00  -6.96671198461866E-14
     -4.49388921435061E-23  -3.95483830490851E-09  -3.95490797202840E-09  -2.22765350653566E-18
      8.29128080169138E-07
      0.00000000000000E+00  -2.23926653785671E-12   0.00000000000000E+00  -1.71223446862591E-14   4.48280187266709E-24
      2.23929972390849E-09   2.23928260156381E-09  -8.79207272331206E-19  -2.18427533138157E-01  -2.18427533138238E-01
      0.00000000000000E+00   0.00000000000000E+00   8.10811044362562E-11   0.00000000000000E+00   8.10811044362562E-11
      3.41523636709032E-18  -3.72118580269096E-02  -3.64807988607834E-02   0.00000000000000E+00  -1.05771781047202E-13
     -7.19513127161878E-23  -2.32025793421895E-09  -2.32036370600007E-09  -2.53602909475911E-18
      8.34128080169138E-07
      0.00000000000000E+00  -9.02007164115120E-13   0.00000000000000E+00  -1.42138579445766E-14  -7.34429740148652E-24
      9.02022109632022E-10   9.02007895774070E-10  -9.85508201272068E-19  -1.62948501949944E-01  -1.62948501950031E-01
      0.00000000000000E+00   0.00000000000000E+00   8.78546553981047E-11   0.00000000000000E+00   8.78546553981047E-11
      3.85450964408084E-18  -5.92133006532606E-02  -5.89014347075918E-02   0.00000000000000E+00  -1.61592877106614E-13
     -8.64536483296345E-23  -9.89700958294981E-10  -9.89862551172174E-10  -2.86900144280878E-18
      8.39128080169138E-07
      0.00000000000000E+00  -2.72595180031939E-13   0.00000000000000E+00  -7.44834872543574E-15  -2.33865144393175E-23
      2.72623911660187E-10   2.72616463311439E-10  -1.10087629079083E-18  -1.06073332919390E-01  -1.06073332919473E-01
      0.00000000000000E+00   0.00000000000000E+00   8.32453314085635E-11   0.00000000000000E+00   8.32453314085635E-11
      4.27073630112366E-18  -8.31665760724246E-02  -8.30544592921381E-02   0.00000000000000E+00  -2.33786230049835E-13
     -9.33519989249840E-23  -3.55628008489859E-10  -3.55861794720002E-10  -3.16986001033283E-18
      8.44128080169138E-07
      0.00000000000000E+00  -7.54045292473795E-14   0.00000000000000E+00  -3.32987331264924E-15  -3.35499023253069E-23
      7.53425099177599E-11   7.53391800444137E-11  -1.20773321105272E-18  -5.61741001137116E-02  -5.61741001137793E-02
      0.00000000000000E+00   0.00000000000000E+00   6.76737854918244E-11   0.00000000000000E+00   6.76737854918244E-11
      4.60910522858279E-18  -1.06979426157599E-01  -1.06934369183212E-01   0.00000000000000E+00  -2.89627916695776E-13
     -9.92339761880979E-23  -1.42723337619443E-10  -1.43012965536238E-10  -3.40137201753006E-18
      8.49128080169138E-07
      0.00000000000000E+00  -3.90340133131989E-14   0.00000000000000E+00  -1.15048153281602E-15  -3.39647452319128E-23
      3.90124030162094E-11   3.90112525346426E-11  -1.27326339471126E-18  -2.66210222898290E-02  -2.66210222898721E-02
      0.00000000000000E+00   0.00000000000000E+00   4.30223836639916E-11   0.00000000000000E+00   4.30223836639916E-11
      4.82421714690274E-18  -1.29936026604318E-01  -1.29910181670276E-01   0.00000000000000E+00  -2.52648816357512E-13
     -1.03806118059306E-22  -8.17809873821730E-11  -8.20336361986343E-11  -3.55095375219149E-18
      8.54128080169137E-07
      0.00000000000000E+00  -3.87584791015763E-14   0.00000000000000E+00  -2.82863711996171E-16  -2.60068146270658E-23
      3.87389335361764E-11   3.87386506724385E-11  -1.30157781696765E-18  -1.42488132332534E-02  -1.42488132332775E-02
      0.00000000000000E+00   0.00000000000000E+00   2.40237512197513E-11   0.00000000000000E+00   2.40237512197513E-11
      4.94433590300150E-18  -1.51877614380069E-01  -1.51857841076148E-01   0.00000000000000E+00  -1.86095244872475E-13
     -1.06833635045690E-22  -6.25763066472104E-11  -6.27624018921897E-11  -3.64275808603385E-18
      8.59128080169137E-07
      0.00000000000000E+00  -4.27996475387075E-14   0.00000000000000E+00  -2.48311193105001E-17  -9.59343778616606E-24
      4.28184634227715E-11   4.28184385916426E-11  -1.31190952057253E-18  -9.56249926013178E-03  -9.56249926014628E-03
      0.00000000000000E+00   0.00000000000000E+00   1.45069699791646E-11   0.00000000000000E+00   1.45069699791646E-11
      5.01687075289732E-18  -1.72786688733616E-01  -1.72768628501146E-01   0.00000000000000E+00  -1.52347954971009E-13
     -1.09137140202662E-22  -5.71730606157269E-11  -5.73254085708070E-11  -3.70496123232480E-18
      8.64128080169137E-07
      0.00000000000000E+00  -4.63815922898010E-14   0.00000000000000E+00   2.71455386070375E-17   1.27217640930204E-23
      4.64229299938066E-11   4.64229571393579E-11  -1.31540286304329E-18  -7.54513905138662E-03  -7.54513905139692E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03069699273925E-11   0.00000000000000E+00   1.03069699273925E-11
      5.06840560253429E-18  -1.92690811740219E-01  -1.92672939235334E-01   0.00000000000000E+00  -1.40286765954890E-13
     -1.11144804186169E-22  -5.65896403006841E-11  -5.67299270667502E-11  -3.75300273949100E-18
      8.69128080169137E-07
      0.00000000000000E+00  -4.94124686176494E-14   0.00000000000000E+00   3.21919434807225E-17   3.44676651715044E-23
      4.94406260094506E-11   4.94406582014286E-11  -1.31644464128770E-18  -6.43809386343160E-03  -6.43809386343996E-03
      0.00000000000000E+00   0.00000000000000E+00   8.35960171934576E-12   0.00000000000000E+00   8.35960171934576E-12
      5.11020361113102E-18  -2.11632316295641E-01  -2.11614106700791E-01   0.00000000000000E+00  -1.34913490218180E-13
     -1.12985864902028E-22  -5.76653464304436E-11  -5.78002599207747E-11  -3.79375896984332E-18
      8.74128080169137E-07
      0.00000000000000E+00  -5.21678107338752E-14   0.00000000000000E+00   3.27830646197333E-17   5.19260339921640E-23
      5.22129735083547E-11   5.22130062914713E-11  -1.31653245328654E-18  -5.70735666019372E-03  -5.70735666020104E-03
      0.00000000000000E+00   0.00000000000000E+00   7.31646229649837E-12   0.00000000000000E+00   7.31646229649837E-12
      5.14678592261351E-18  -2.29656402398813E-01  -2.29637648140290E-01   0.00000000000000E+00  -1.30634509547072E-13
     -1.14697627635969E-22  -5.93988340783076E-11  -5.95294685879694E-11  -3.83025346932696E-18
      8.79128080169137E-07
      0.00000000000000E+00  -5.49231528501010E-14   0.00000000000000E+00   3.42053031433468E-17   6.43351940736306E-23
      5.49414583726094E-11   5.49414925779769E-11  -1.31617236548252E-18  -5.18276035403611E-03  -5.18276035404277E-03
      0.00000000000000E+00   0.00000000000000E+00   6.65662090797735E-12   0.00000000000000E+00   6.65662090797735E-12
      5.18006902715339E-18  -2.46806065207220E-01  -2.46786659352682E-01   0.00000000000000E+00  -1.26270090594337E-13
     -1.16300878892349E-22  -6.14718433952434E-11  -6.15981134859540E-11  -3.86389666167088E-18
      8.84128080169137E-07
      0.00000000000000E+00  -5.76784949663268E-14   0.00000000000000E+00   3.64137576285522E-17   7.26895190937532E-23
      5.77031168665668E-11   5.77031532803971E-11  -1.31555156057986E-18  -4.79769685548373E-03  -4.79769685548990E-03
      0.00000000000000E+00   0.00000000000000E+00   6.17263798712470E-12   0.00000000000000E+00   6.17263798712470E-12
      5.21093221708902E-18  -2.63118397486879E-01  -2.63098274187917E-01   0.00000000000000E+00  -1.21795347169899E-13
     -1.17812474477606E-22  -6.37539959202343E-11  -6.38757912675220E-11  -3.89538065650916E-18
      8.89128080169137E-07
      0.00000000000000E+00  -6.05256818197601E-14   0.00000000000000E+00   3.87858919563305E-17   7.83658206197317E-23
      6.05196406842134E-11   6.05196794701837E-11  -1.31474775319854E-18  -4.52071044354880E-03  -4.52071044355457E-03
      0.00000000000000E+00   0.00000000000000E+00   5.77382865391071E-12   0.00000000000000E+00   5.77382865391071E-12
      5.23980136035857E-18  -2.78626854839765E-01  -2.78605969983696E-01   0.00000000000000E+00  -1.17348567334148E-13
     -1.19244884753772E-22  -6.61761595566411E-11  -6.62935081240945E-11  -3.92505360716003E-18
      8.94128080169137E-07
      0.00000000000000E+00  -6.33728686731935E-14   0.00000000000000E+00   4.10247402675067E-17   8.24534659015135E-23
      6.34017746467434E-11   6.34018156715661E-11  -1.31379198829948E-18  -4.33707782012039E-03  -4.33707782012581E-03
      0.00000000000000E+00   0.00000000000000E+00   5.42023645834228E-12   0.00000000000000E+00   5.42023645834228E-12
      5.26690254265028E-18  -2.93374030471400E-01  -2.93352349147738E-01   0.00000000000000E+00  -1.13110309573953E-13
     -1.20607436604853E-22  -6.87089418202135E-11  -6.88220521299081E-11  -3.95311055435080E-18
      8.99128080169137E-07
      0.00000000000000E+00  -6.64037450010418E-14   0.00000000000000E+00   4.41200866122559E-17   8.56554399354324E-23
      6.63712088318468E-11   6.63712529520190E-11  -1.31268534819999E-18  -4.24432197729922E-03  -4.24432197730431E-03
      0.00000000000000E+00   0.00000000000000E+00   5.09164390007614E-12   0.00000000000000E+00   5.09164390007614E-12
      5.29236076215066E-18  -3.07412630442496E-01  -3.07390117276499E-01   0.00000000000000E+00  -1.09190604966626E-13
     -1.21907709009307E-22  -7.13537062470068E-11  -7.14628968520953E-11  -3.97967541395068E-18
      9.04128080169137E-07
      0.00000000000000E+00  -6.95264660660977E-14   0.00000000000000E+00   4.81126607336973E-17   8.83987221060466E-23
      6.94828848419840E-11   6.94829329547332E-11  -1.31139368483196E-18  -4.25446990442230E-03  -4.25446990442708E-03
      0.00000000000000E+00   0.00000000000000E+00   4.77897900272247E-12   0.00000000000000E+00   4.77897900272247E-12
      5.31625565716427E-18  -3.20821336857005E-01  -3.20797942023373E-01   0.00000000000000E+00  -1.05759718734515E-13
     -1.23153600782039E-22  -7.41561522385978E-11  -7.42619119574555E-11  -4.00486197233231E-18
      9.09128080169137E-07
      0.00000000000000E+00  -7.28328766055687E-14   0.00000000000000E+00   5.44983946230272E-17   9.09500959464703E-23
      7.28412813202788E-11   7.28413358187644E-11  -1.30982885050377E-18  -4.40472691835706E-03  -4.40472691836151E-03
      0.00000000000000E+00   0.00000000000000E+00   4.44301475235319E-12   0.00000000000000E+00   4.44301475235319E-12
      5.33847073092604E-18  -3.33630517848991E-01  -3.33606170966811E-01   0.00000000000000E+00  -1.02180780846332E-13
     -1.24344702282948E-22  -7.71821697901473E-11  -7.72843505711180E-11  -4.02864188042227E-18
      9.14128080169137E-07
      0.00000000000000E+00  -7.66903555682848E-14   0.00000000000000E+00   6.65199291312861E-17   9.35474229912775E-23
      7.66904600047301E-11   7.66905265247528E-11  -1.30777753249122E-18  -4.78780628769866E-03  -4.78780628770268E-03
      0.00000000000000E+00   0.00000000000000E+00   4.02625027436807E-12   0.00000000000000E+00   4.02625027436807E-12
      5.35860198229788E-18  -3.45839586576088E-01  -3.45814158492463E-01   0.00000000000000E+00  -9.76560240559151E-14
     -1.25471260677590E-22  -8.06191207749393E-11  -8.07167767991207E-11  -4.05082444980666E-18
      9.19128080169137E-07
      0.00000000000000E+00  -8.16499713774913E-14   0.00000000000000E+00   9.29931856887736E-17   9.65869231686422E-23
      8.16750776150506E-11   8.16751706083328E-11  -1.30470122108485E-18  -5.63700226410476E-03  -5.63700226410818E-03
      0.00000000000000E+00   0.00000000000000E+00   3.41488102353247E-12   0.00000000000000E+00   3.41488102353247E-12
      5.37567638741554E-18  -3.57457388761914E-01  -3.57430583089651E-01   0.00000000000000E+00  -9.09136124662758E-14
     -1.26509165368088E-22  -8.49991380192725E-11  -8.50900516318652E-11  -4.07097516633069E-18
      9.24128080169137E-07
      0.00000000000000E+00  -8.96404635145461E-14   0.00000000000000E+00   1.62246496060358E-16   1.01013646454754E-22
      8.96181855716504E-11   8.96183478182475E-11  -1.29918495589910E-18  -7.56322575680520E-03  -7.56322575680750E-03
      0.00000000000000E+00   0.00000000000000E+00   2.29509894830275E-12   0.00000000000000E+00   2.29509894830275E-12
      5.38715188215706E-18  -3.68494900851002E-01  -3.68465945747360E-01   0.00000000000000E+00  -7.82700907801149E-14
     -1.27392817157652E-22  -9.18351766756429E-11  -9.19134467665504E-11  -4.08796692625796E-18
      9.29128080169137E-07
      0.00000000000000E+00  -1.05896982000278E-13   0.00000000000000E+00   3.27328218307775E-16   1.09107783136743E-22
      1.05869739585426E-10   1.05870066913753E-10  -1.28764436132114E-18  -1.20976238493968E-02  -1.20976238493967E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.21574194215001E-13   0.00000000000000E+00  -1.21574194215001E-13
      5.38654401118598E-18  -3.78944615452851E-01  -3.78911302078550E-01   0.00000000000000E+00  -5.05515510229626E-14
     -1.27954076375816E-22  -1.05697941168387E-10  -1.05748492719538E-10  -4.09889964986485E-18
      9.34128080169137E-07
      0.00000000000000E+00  -1.44930995313477E-13   0.00000000000000E+00   7.22326442990746E-16   1.24470101518071E-22
      1.44926390620626E-10   1.44927112947194E-10  -1.26316243703191E-18  -2.21022560049513E-02  -2.21022560049462E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.08934567551728E-12   0.00000000000000E+00  -5.08934567551728E-12
      5.36109728280840E-18  -3.88737910296226E-01  -3.88693858058592E-01   0.00000000000000E+00   4.65594374570016E-15
     -1.27885025215307E-22  -1.39842423215294E-10  -1.39837767271676E-10  -4.09793484577648E-18
      9.39128080169137E-07
      0.00000000000000E+00  -2.36959421995419E-13   0.00000000000000E+00   1.46253483657655E-15   1.46426769917144E-22
      2.36987373373763E-10   2.36988835908746E-10  -1.22042805958859E-18  -3.95292972222564E-02  -3.95292972222441E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.22901776928297E-11   0.00000000000000E+00  -1.22901776928297E-11
      5.29964639434425E-18  -3.97665568727341E-01  -3.97594783169972E-01   0.00000000000000E+00   7.47883184921566E-14
     -1.27015607481671E-22  -2.24773446534281E-10  -2.24698658215916E-10  -4.07921833475565E-18
      9.44128080169137E-07
      0.00000000000000E+00  -4.26526959591754E-13   0.00000000000000E+00   2.49738200925692E-15   1.66538225390538E-22
      4.26518260395650E-10   4.26520757777826E-10  -1.16482294122441E-18  -6.20256048858422E-02  -6.20256048858237E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.84390304945313E-11   0.00000000000000E+00  -1.84390304945313E-11
      5.20745124187159E-18  -4.05302835098187E-01  -4.05174278739960E-01   0.00000000000000E+00   1.16818386980778E-13
     -1.25655005368429E-22  -4.08198545670150E-10  -4.08081727283295E-10  -4.04262830064718E-18
      9.49128080169137E-07
      0.00000000000000E+00  -7.70669189908357E-13   0.00000000000000E+00   3.99611368058693E-15   1.81122629206365E-22
      7.70704747965619E-10   7.70708744079481E-10  -1.10636330756465E-18  -8.60778317125615E-02  -8.60778317125393E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.22766775384178E-11   0.00000000000000E+00  -2.22766775384178E-11
      5.09606785417950E-18  -4.10969066314210E-01  -4.10733289317611E-01   0.00000000000000E+00   1.28291849755113E-13
     -1.24137058316913E-22  -7.48560358390694E-10  -7.48432066541063E-10  -3.98970454661485E-18
      9.54128080169136E-07
      0.00000000000000E+00  -1.33257529214401E-12   0.00000000000000E+00   6.07712458433876E-15   1.92032818427005E-22
      1.33252363236039E-09   1.33252970948517E-09  -1.05140000637162E-18  -1.09818999507215E-01  -1.09818999507190E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.49969678187261E-11   0.00000000000000E+00  -2.49969678187261E-11
      4.97108301508587E-18  -4.13723965090819E-01  -4.13312053249353E-01   0.00000000000000E+00   1.31622260517694E-13
     -1.22542094338182E-22  -1.30766436392684E-09  -1.30753274166644E-09  -3.91968300871425E-18
      9.59128080169136E-07
      0.00000000000000E+00  -2.16615812703952E-12   0.00000000000000E+00   8.69084437163826E-15   2.00635959969156E-22
      2.16618589558930E-09   2.16619458643387E-09  -1.00198350239823E-18  -1.32660262504889E-01  -1.32660262504861E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.76773289981519E-11   0.00000000000000E+00  -2.76773289981519E-11
      4.83269637009511E-18  -4.12420358278582E-01  -4.11746657211217E-01   0.00000000000000E+00   1.39844044608159E-13
     -1.20799979910601E-22  -2.13865710148020E-09  -2.13851725743572E-09  -3.83071286769688E-18
      9.64128080169136E-07
      0.00000000000000E+00  -3.30080801050130E-12   0.00000000000000E+00   1.15985618765892E-14   2.06807645902727E-22
      3.30075912351459E-09   3.30077072207668E-09  -9.57978613607824E-19  -1.54477286998586E-01  -1.54477286998555E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05487171792425E-11   0.00000000000000E+00  -3.05487171792425E-11
      4.67995278419890E-18  -4.05828048427100E-01  -4.04797817015108E-01   0.00000000000000E+00   1.57109734638397E-13
     -1.18785861907638E-22  -3.27037911463195E-09  -3.27022200489744E-09  -3.72197417059107E-18
      9.69128080169136E-07
      0.00000000000000E+00  -4.73331037672710E-12   0.00000000000000E+00   1.44865961000780E-14   2.09859216802319E-22
      4.73329539863720E-09   4.73330988523351E-09  -9.18549622902032E-19  -1.75262584784266E-01  -1.75262584784232E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.33748264298317E-11   0.00000000000000E+00  -3.33748264298317E-11
      4.51307865204974E-18  -3.92785935636497E-01  -3.91305283679110E-01   0.00000000000000E+00   1.84189745047696E-13
     -1.16353243265673E-22  -4.70011924854861E-09  -4.69993505880368E-09  -3.59452902914771E-18
      9.74128080169136E-07
      0.00000000000000E+00  -6.43565258086861E-12   0.00000000000000E+00   1.70861727363764E-14   2.09319678969044E-22
      6.43565897298258E-09   6.43567605915552E-09  -8.82774626909561E-19  -1.95047277189845E-01  -1.95047277189810E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.58645386282457E-11   0.00000000000000E+00  -3.58645386282457E-11
      4.33375595890851E-18  -3.72317481087932E-01  -3.70301285899878E-01   0.00000000000000E+00   2.19821564903988E-13
     -1.13348399034329E-22  -6.40003134209206E-09  -6.39981152052727E-09  -3.45098133199895E-18
      9.79128080169136E-07
      0.00000000000000E+00  -8.36356545959180E-12   0.00000000000000E+00   1.92986247685595E-14   2.05418609649110E-22
      8.36353854341874E-09   8.36355784204372E-09  -8.49864958581508E-19  -2.13874706851380E-01  -2.13874706851343E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.78325378568734E-11   0.00000000000000E+00  -3.78325378568734E-11
      4.14459326962414E-18  -3.43702211559249E-01  -3.41079246262416E-01   0.00000000000000E+00   2.59830078475865E-13
     -1.09622056490366E-22  -8.32598513426521E-09  -8.32572530418684E-09  -3.29472831104264E-18
      9.84128080169136E-07
      0.00000000000000E+00  -1.04545027468584E-11   0.00000000000000E+00   2.08816102431290E-14   1.99208523150773E-22
      1.04544941588180E-08   1.04545150404285E-08  -8.19222015945454E-19  -2.31790111885684E-01  -2.31790111885645E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.92886290298082E-11   0.00000000000000E+00  -3.92886290298082E-11
      3.94815012447510E-18  -3.06559462037948E-01  -3.03278168614281E-01   0.00000000000000E+00   2.94992374374140E-13
     -1.05025820047284E-22  -1.04155214037729E-08  -1.04152264113987E-08  -3.12892810852965E-18
      9.89128080169136E-07
      0.00000000000000E+00  -1.25928319185240E-11   0.00000000000000E+00   2.13281491157806E-14   1.91321113660174E-22
      1.25928380497005E-08   1.25928593778498E-08  -7.90482465470062E-19  -2.48836018090127E-01  -2.48836018090087E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.06219601064404E-11   0.00000000000000E+00  -4.06219601064404E-11
      3.74504032394290E-18  -2.61088732628237E-01  -2.57134120700964E-01   0.00000000000000E+00   3.08033443336244E-13
     -9.93908075095972E-23  -1.25525454511866E-08  -1.25522374177433E-08  -2.95455785847284E-18
      9.94128080169136E-07
      0.00000000000000E+00  -1.45264391709541E-11   0.00000000000000E+00   1.92885658130701E-14   1.77845415510936E-22
      1.45264529925868E-08   1.45264722811528E-08  -7.63602485617726E-19  -2.65048689311576E-01  -2.65048689311533E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28393707268518E-11   0.00000000000000E+00  -4.28393707268518E-11
      3.53084347030864E-18  -2.08658585123508E-01  -2.04095419428890E-01   0.00000000000000E+00   2.79742532553493E-13
     -9.28352293448904E-23  -1.44839126529584E-08  -1.44836329104259E-08  -2.76724098469091E-18
      9.99128080169136E-07
      0.00000000000000E+00  -1.59373580239361E-11   0.00000000000000E+00   1.40824562132208E-14   1.50503344601874E-22
      1.59373620131894E-08   1.59373760956458E-08  -7.38638575095282E-19  -2.80462034360262E-01  -2.80462034360215E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.61356197347790E-11   0.00000000000000E+00  -4.61356197347790E-11
      3.30016537163475E-18  -1.52043057690540E-01  -1.47036361405479E-01   0.00000000000000E+00   2.19324752303155E-13
     -8.66562765932222E-23  -1.58914598006633E-08  -1.58912404759110E-08  -2.56152679653947E-18
      1.00412808016914E-06
      0.00000000000000E+00  -1.65605245658891E-11   0.00000000000000E+00   2.30317287027435E-13   1.09146221849751E-22
      1.65605781492685E-08   1.65608084665556E-08  -7.15327038733507E-19  -2.95119615984447E-01  -2.95119615984399E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.81693457194718E-11   0.00000000000000E+00  -4.81693457194718E-11
      3.05931864303739E-18  -9.51328809739793E-02  -8.99304350116171E-02   0.00000000000000E+00  -5.93973470412616E-14
     -7.96369931618214E-23  -1.65125797234891E-08  -1.65126391208362E-08  -2.34399160430388E-18
      1.00912808016914E-06
      0.00000000000000E+00  -1.49887855780567E-11   0.00000000000000E+00  -1.53653332385276E-14   5.82188956045056E-23
      1.49887484311703E-08   1.49887330658371E-08  -6.92875458580094E-19  -3.09077183537011E-01  -3.09077183536965E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.59394084474215E-11   0.00000000000000E+00  -4.59394084474215E-11
      2.82962160080028E-18  -4.83199410115597E-02  -4.36119969570235E-02   0.00000000000000E+00   1.28990918426811E-13
     -5.41114011170388E-23  -1.49429226483080E-08  -1.49427936573897E-08  -2.13674614222019E-18
      1.01412808016914E-06
      0.00000000000000E+00  -1.09069299223426E-11   0.00000000000000E+00  -4.01218201557579E-14   2.55844695877791E-23
      1.09070133876643E-08   1.09069732658441E-08  -6.68076247969209E-19  -3.22412496120585E-01  -3.22412496120551E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.42173299058615E-11   0.00000000000000E+00  -3.42173299058615E-11
      2.65853495127097E-18  -2.29985882415389E-02  -1.95729581264770E-02   0.00000000000000E+00   9.84516318716861E-14
     -2.55658611210345E-23  -1.08728543875701E-08  -1.08727559359383E-08  -1.99045870330176E-18
      1.01912808016914E-06
      0.00000000000000E+00  -7.94438607897665E-12   0.00000000000000E+00  -2.18418111912421E-14   1.29049157168456E-23
      7.94439479897754E-09   7.94437295716636E-09  -6.40955644274200E-19  -3.35148575474958E-01  -3.35148575474935E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.36503826349303E-11   0.00000000000000E+00  -2.36503826349303E-11
      2.54028303809632E-18  -1.28594581642506E-02  -1.03639100699220E-02   0.00000000000000E+00   5.20761315438357E-14
     -1.34282318912321E-23  -7.92077465066295E-09  -7.92072257453142E-09  -1.89932739382212E-18
      1.02412808016914E-06
      0.00000000000000E+00  -6.71504427145390E-12   0.00000000000000E+00  -1.19726254833689E-14   8.15948659985296E-24
      6.71509894871315E-09   6.71508697608767E-09  -6.13320039413581E-19  -3.47285167523916E-01  -3.47285167523897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.86860963354680E-11   0.00000000000000E+00  -1.86860963354680E-11
      2.44685255641898E-18  -8.99458922710826E-03  -6.88477862744582E-03   0.00000000000000E+00   3.19311014107426E-14
     -9.10097750827241E-24  -6.69643281085360E-09  -6.69640087975220E-09  -1.83353251700540E-18
      1.02912808016914E-06
      0.00000000000000E+00  -6.30192664349445E-12   0.00000000000000E+00  -3.93647197718050E-15   6.02206491039260E-24
      6.30193276298398E-09   6.30192882651200E-09  -5.86096145865514E-19  -3.58832186832297E-01  -3.58832186832280E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66005794005808E-11   0.00000000000000E+00  -1.66005794005808E-11
      2.36384965941608E-18  -7.25424985355664E-03  -5.27395267044057E-03   0.00000000000000E+00   1.97438476154308E-14
     -7.07975032243614E-24  -6.28534799095903E-09  -6.28532824711143E-09  -1.77775351355056E-18
      1.03412808016914E-06
      0.00000000000000E+00  -6.16112866135531E-12   0.00000000000000E+00  -1.26287251645594E-15   4.79496547193849E-24
      6.16116888771718E-09   6.16116762484467E-09  -5.59667963727927E-19  -3.69799872446416E-01  -3.69799872446401E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55310502335503E-11   0.00000000000000E+00  -1.55310502335503E-11
      2.28619440824833E-18  -6.25390846975056E-03  -4.31762200844989E-03   0.00000000000000E+00   1.48059290914235E-14
     -5.84118727319066E-24  -6.14565138054020E-09  -6.14563657461112E-09  -1.72652644452040E-18
      1.03912808016914E-06
      0.00000000000000E+00  -6.10152142690762E-12   0.00000000000000E+00  -4.75006044802619E-16   3.97600378498373E-24
      6.10155695335523E-09   6.10155647834919E-09  -5.34289912349591E-19  -3.80176841813224E-01  -3.80176841813209E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47784318355747E-11   0.00000000000000E+00  -1.47784318355747E-11
      2.21230224907045E-18  -5.57700747894851E-03  -3.65926411648025E-03   0.00000000000000E+00   1.23460043182919E-14
     -4.96444434373664E-24  -6.08679039251793E-09  -6.08677804651361E-09  -1.67801233672086E-18
      1.04412808016914E-06
      0.00000000000000E+00  -6.06781440835246E-12   0.00000000000000E+00  -2.32029562806490E-16   3.39402902566535E-24
      6.06781337659506E-09   6.06781314456550E-09  -5.10317592413029E-19  -3.89883645677363E-01  -3.89883645677349E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40285915577811E-11   0.00000000000000E+00  -1.40285915577811E-11
      2.14215929128155E-18  -5.08653164090991E-03  -3.17918233248502E-03   0.00000000000000E+00   1.06259988784920E-14
     -4.31158754081779E-24  -6.05379517900660E-09  -6.05378455300773E-09  -1.63184169886852E-18
      1.04912808016914E-06
      0.00000000000000E+00  -6.04384293194130E-12   0.00000000000000E+00  -1.49017176828140E-16   2.97284511433505E-24
      6.04385568292655E-09   6.04385553390938E-09  -4.88440900338938E-19  -3.98690700815299E-01  -3.98690700815286E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.29676682872218E-11   0.00000000000000E+00  -1.29676682872218E-11
      2.07732094984544E-18  -4.72624617311780E-03  -2.82610991642753E-03   0.00000000000000E+00   9.03675771571685E-15
     -3.82697449990008E-24  -6.03089690237986E-09  -6.03088786562215E-09  -1.58888004950650E-18
      1.05412808016914E-06
      0.00000000000000E+00  -6.02363708975564E-12   0.00000000000000E+00  -1.28338966210775E-16   2.67280732850752E-24
      6.02365657178503E-09   6.02365644344607E-09  -4.69868285322425E-19  -4.06147011445401E-01  -4.06147011445390E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11915173110916E-11   0.00000000000000E+00  -1.11915173110916E-11
      2.02136336328998E-18  -4.46900259556877E-03  -2.57467004558245E-03   0.00000000000000E+00   7.27270338855710E-15
     -3.48593433221321E-24  -6.01247219883836E-09  -6.01246492613497E-09  -1.55149507796756E-18
      1.05912808016914E-06
      0.00000000000000E+00  -6.00379862651882E-12   0.00000000000000E+00  -1.45733479553846E-16   2.47358033918406E-24
      6.00384263588797E-09   6.00384249015449E-09  -4.56416734993449E-19  -4.11543238322982E-01  -4.11543238322973E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.23535320563341E-12   0.00000000000000E+00  -8.23535320563341E-12
      1.98018659726181E-18  -4.30263188326310E-03  -2.41361015128874E-03   0.00000000000000E+00   5.10080062209193E-15
     -3.28171942398154E-24  -5.99561223774947E-09  -5.99560713694885E-09  -1.52376986226836E-18
      1.06412808016914E-06
      0.00000000000000E+00  -5.98157220011459E-12   0.00000000000000E+00  -1.47396718995915E-16   2.36814743956560E-24
      5.98156372259451E-09   5.98156357519779E-09  -4.50509466626098E-19  -4.13913115420524E-01  -4.13913115420521E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.65917994671315E-12   0.00000000000000E+00  -3.65917994671315E-12
      1.96189069752825E-18  -4.22694057180872E-03  -2.34349619024262E-03   0.00000000000000E+00   2.24513405201102E-15
     -3.22671079783888E-24  -5.97790664038512E-09  -5.97790439525107E-09  -1.51138123090215E-18
      1.06912808016914E-06
      0.00000000000000E+00  -5.95328402105468E-12   0.00000000000000E+00  -2.94760896169675E-16   2.36256568798334E-24
      5.95332392570070E-09   5.95332363093981E-09  -4.55044627575170E-19  -4.12093378067096E-01  -4.12093378067099E-01
      0.00000000000000E+00   0.00000000000000E+00   2.79437281100399E-12   0.00000000000000E+00   2.79437281100399E-12
      1.97586256158327E-18  -4.25711335057315E-03  -2.38053330466617E-03   0.00000000000000E+00  -1.39558565240540E-15
     -3.36522927237466E-24  -5.95611660816515E-09  -5.95611800375081E-09  -1.52081793400810E-18
      1.07412808016914E-06
      0.00000000000000E+00  -5.91314787089499E-12   0.00000000000000E+00  -4.62697134177414E-16   2.48103176992831E-24
      5.91314819530989E-09   5.91314773261276E-09  -4.73091370359785E-19  -4.04854209133999E-01  -4.04854209134010E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10073310015941E-11   0.00000000000000E+00   1.10073310015941E-11
      2.03089921659124E-18  -4.43641637592168E-03  -2.56990750516619E-03   0.00000000000000E+00  -6.29247315511098E-15
     -3.81025954320046E-24  -5.92414877114118E-09  -5.92415506361434E-09  -1.55780784623145E-18
      1.07912808016914E-06
      0.00000000000000E+00  -5.84766257326602E-12   0.00000000000000E+00  -7.79503719894744E-16   2.77876379255106E-24
      5.84768968508521E-09   5.84768890558149E-09  -5.07442204262554E-19  -3.91049773904357E-01  -3.91049773904377E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04361550193548E-11   0.00000000000000E+00   2.04361550193548E-11
      2.13307999168801E-18  -4.87191222637792E-03  -3.02305798066707E-03   0.00000000000000E+00  -1.28861313774194E-14
     -4.84954075760931E-24  -5.86811217446946E-09  -5.86812506060084E-09  -1.62563778742546E-18
      1.08412808016914E-06
      0.00000000000000E+00  -5.72201897276612E-12   0.00000000000000E+00  -2.52274923387980E-15   3.36518819253774E-24
      5.72193107026706E-09   5.72192854751783E-09  -5.59935310563714E-19  -3.69728175653711E-01  -3.69728175653741E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03943293386788E-11   0.00000000000000E+00   3.03943293386788E-11
      2.28505163838141E-18  -5.83495099041650E-03  -4.02258423938147E-03   0.00000000000000E+00  -2.09277087239421E-14
     -7.26112707959301E-24  -5.75230194914777E-09  -5.75232287685650E-09  -1.72511632781769E-18
      1.08912808016914E-06
      0.00000000000000E+00  -5.44014747427622E-12   0.00000000000000E+00   4.00324823782290E-14   4.41693290577397E-24
      5.44010941707115E-09   5.44014944955353E-09  -6.30261143515478E-19  -3.40200352374217E-01  -3.40200352374258E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09005410929064E-11   0.00000000000000E+00   4.09005410929064E-11
      2.48955434384594E-18  -8.03813923925216E-03  -6.31125936275113E-03   0.00000000000000E+00  -7.89626798959290E-14
     -1.31713984442575E-23  -5.48097102796653E-09  -5.48104999064644E-09  -1.85929320033046E-18
      1.09412808016914E-06
      0.00000000000000E+00  -4.77546711110535E-12   0.00000000000000E+00  -6.01433424989134E-15   5.99432776537113E-24
      4.77544282150007E-09   4.77543680716583E-09  -7.14716649608383E-19  -3.02131585168596E-01  -3.02131585168650E-01
      0.00000000000000E+00   0.00000000000000E+00   5.38771908194185E-11   0.00000000000000E+00   5.38771908194185E-11
      2.75894029794303E-18  -1.32266605696287E-02  -1.17051120050990E-02   0.00000000000000E+00  -5.37811827484977E-14
     -2.72525831284593E-23  -4.82926021680247E-09  -4.82931399798525E-09  -2.04422364833465E-18
      1.09912808016914E-06
      0.00000000000000E+00  -3.44702483213569E-12   0.00000000000000E+00  -1.37853615768050E-14   6.79249866293911E-24
      3.44708581884563E-09   3.44707203348406E-09  -8.08073629645415E-19  -2.55811906589671E-01  -2.55811906589742E-01
      0.00000000000000E+00   0.00000000000000E+00   7.08871562161532E-11   0.00000000000000E+00   7.08871562161532E-11
      3.11337607902380E-18  -2.43867215726696E-02  -2.32783401890105E-02   0.00000000000000E+00  -7.89528519259271E-14
     -5.25821481002180E-23  -3.51788023684823E-09  -3.51795918970021E-09  -2.30530244937838E-18
      1.10412808016914E-06
      0.00000000000000E+00  -1.77205235968202E-12   0.00000000000000E+00  -1.73505170775020E-14   1.49472758136360E-24
      1.77207211388348E-09   1.77205476336640E-09  -9.08990055343824E-19  -2.02773869583597E-01  -2.02773869583683E-01
      0.00000000000000E+00   0.00000000000000E+00   8.52693958255786E-11   0.00000000000000E+00   8.52693958255786E-11
      3.53972305815169E-18  -4.28884864505360E-02  -4.23033148230069E-02   0.00000000000000E+00  -1.21089744777325E-13
     -7.71298544135484E-23  -1.85720306944713E-09  -1.85732415919198E-09  -2.63073300280787E-18
      1.10912808016914E-06
      0.00000000000000E+00  -6.43280539401517E-13   0.00000000000000E+00  -2.33390359975838E-14  -1.26755075397698E-23
      6.43312854870470E-10   6.43289515834459E-10  -1.01946395404182E-18  -1.45893533221785E-01  -1.45893533221873E-01
      0.00000000000000E+00   0.00000000000000E+00   8.83460004589504E-11   0.00000000000000E+00   8.83460004589504E-11
      3.98145306044645E-18  -6.58421528317811E-02  -6.56116409461209E-02   0.00000000000000E+00  -1.71619674050784E-13
     -8.96973036832872E-23  -7.31463896619270E-10  -7.31635516293410E-10  -2.96198910640462E-18
      1.11412808016913E-06
      0.00000000000000E+00  -1.80199374401167E-13   0.00000000000000E+00  -5.74529220313116E-15  -2.78676837846094E-23
      1.80205503132865E-10   1.80199757840634E-10  -1.13637929905073E-18  -8.93515036529506E-02  -8.93515036530310E-02
      0.00000000000000E+00   0.00000000000000E+00   8.03636275825236E-11   0.00000000000000E+00   8.03636275825236E-11
      4.38327119835906E-18  -8.99290961460462E-02  -8.98470040327635E-02   0.00000000000000E+00  -2.57254864933754E-13
     -9.51417435249947E-23  -2.60306130558129E-10  -2.60563385423158E-10  -3.24689189930833E-18
      1.11912808016913E-06
      0.00000000000000E+00  -5.49231528501010E-14   0.00000000000000E+00  -2.41991382490368E-15  -3.48813330642380E-23
      5.49057776852780E-11   5.49033577714182E-11  -1.23329814716442E-18  -4.45730915588692E-02  -4.45730915589300E-02
      0.00000000000000E+00   0.00000000000000E+00   6.07754594170605E-11   0.00000000000000E+00   6.07754594170605E-11
      4.68714849544436E-18  -1.13546296844963E-01  -1.13509851720123E-01   0.00000000000000E+00  -2.89084151203468E-13
     -1.00802580354976E-22  -1.15389733037174E-10  -1.15678817188479E-10  -3.45385034827994E-18
      1.12412808016913E-06
      0.00000000000000E+00  -3.72889633062559E-14   0.00000000000000E+00  -7.78639004114072E-16  -3.26567522309898E-23
      3.72599144501621E-11   3.72591358111254E-11  -1.28528977270823E-18  -2.13831425724024E-02  -2.13831425724385E-02
      0.00000000000000E+00   0.00000000000000E+00   3.61413182515326E-11   0.00000000000000E+00   3.61413182515326E-11
      4.86785508670203E-18  -1.36227268329994E-01  -1.36204143361052E-01   0.00000000000000E+00  -2.29716142086912E-13
     -1.04817710527930E-22  -7.31707379204663E-11  -7.34004540626581E-11  -3.58256531399380E-18
      1.12912808016913E-06
      0.00000000000000E+00  -3.97687712108591E-14   0.00000000000000E+00  -1.59489467666135E-16  -2.21422334903258E-23
      3.97805187653131E-11   3.97803592758233E-11  -1.30619207899887E-18  -1.22552479295691E-02  -1.22552479295894E-02
      0.00000000000000E+00   0.00000000000000E+00   2.02729484070518E-11   0.00000000000000E+00   2.02729484070518E-11
      4.96921982873729E-18  -1.57878015147575E-01  -1.57859095391464E-01   0.00000000000000E+00  -1.71773571613595E-13
     -1.07544917105898E-22  -5.98815341111538E-11  -6.00533076828750E-11  -3.66302774973842E-18
      1.13412808016913E-06
      0.00000000000000E+00  -4.39017843851978E-14   0.00000000000000E+00   3.54348762278360E-18  -3.43968262156191E-24
      4.38847739326400E-11   4.38847774761241E-11  -1.31356823818209E-18  -8.74529027345702E-03  -8.74529027346986E-03
      0.00000000000000E+00   0.00000000000000E+00   1.28398335160443E-11   0.00000000000000E+00   1.28398335160443E-11
      5.03341899631751E-18  -1.78500338901922E-01  -1.78482467986252E-01   0.00000000000000E+00  -1.47062416096108E-13
     -1.09731416310024E-22  -5.65775485759627E-11  -5.67246109921685E-11  -3.71985075813542E-18
      1.13912808016913E-06
      0.00000000000000E+00  -4.73000396618763E-14   0.00000000000000E+00   3.12326490430656E-17   1.93730211384227E-23
      4.72892901157454E-11   4.72893213484138E-11  -1.31599176154088E-18  -7.12326999969653E-03  -7.12326999970609E-03
      0.00000000000000E+00   0.00000000000000E+00   9.56130860976005E-12   0.00000000000000E+00   9.56130860976005E-12
      5.08122553936631E-18  -1.98128549220471E-01  -1.98110638721203E-01   0.00000000000000E+00  -1.38287990913099E-13
     -1.11682753371932E-22  -5.67123419671489E-11  -5.68506299581737E-11  -3.76523377782543E-18
      1.14412808016913E-06
      0.00000000000000E+00  -5.02390712525171E-14   0.00000000000000E+00   3.28586750398904E-17   4.01136673699818E-23
      5.02072364302320E-11   5.02072692889472E-11  -1.31662583302754E-18  -6.16946109244914E-03  -6.16946109245713E-03
      0.00000000000000E+00   0.00000000000000E+00   7.98214628668063E-12   0.00000000000000E+00   7.98214628668063E-12
      5.12113627079971E-18  -2.16806763522379E-01  -2.16788431358058E-01   0.00000000000000E+00  -1.33613947143983E-13
     -1.13483685942184E-22  -5.80558016283707E-11  -5.81894155756281E-11  -3.80451043777217E-18
      1.14912808016913E-06
      0.00000000000000E+00  -5.29944133687429E-14   0.00000000000000E+00   3.32733839766367E-17   5.60639005570863E-23
      5.29557844984080E-11   5.29558177718480E-11  -1.31652984729831E-18  -5.51685846047862E-03  -5.51685846048571E-03
      0.00000000000000E+00   0.00000000000000E+00   7.09128774362162E-12   0.00000000000000E+00   7.09128774362162E-12
      5.15659270951782E-18  -2.34580047586245E-01  -2.34561130282010E-01   0.00000000000000E+00  -1.29377243293851E-13
     -1.15162189997035E-22  -5.99177282720607E-11  -6.00471055154697E-11  -3.84006286221951E-18
      1.15412808016913E-06
      0.00000000000000E+00  -5.56579107477612E-14   0.00000000000000E+00   3.49588824463850E-17   6.71391555281216E-23
      5.56922576211446E-11   5.56922925800942E-11  -1.31606797707835E-18  -5.04229266755452E-03  -5.04229266756102E-03
      0.00000000000000E+00   0.00000000000000E+00   6.50016121322904E-12   0.00000000000000E+00   6.50016121322904E-12
      5.18909351558397E-18  -2.51490145761811E-01  -2.51470552698269E-01   0.00000000000000E+00  -1.24984523758002E-13
     -1.16737556298329E-22  -6.20674692694480E-11  -6.21924537933228E-11  -3.87302553850562E-18
      1.15912808016913E-06
      0.00000000000000E+00  -5.85050976011945E-14   0.00000000000000E+00   3.71930720579405E-17   7.45672226604781E-23
      5.84708112548417E-11   5.84708484479884E-11  -1.31537999615800E-18  -4.69400958741670E-03  -4.69400958742275E-03
      0.00000000000000E+00   0.00000000000000E+00   6.04927890949159E-12   0.00000000000000E+00   6.04927890949159E-12
      5.21933991013142E-18  -2.67572232250295E-01  -2.67551905993138E-01   0.00000000000000E+00  -1.20510257202685E-13
     -1.18225398520644E-22  -6.43996171001594E-11  -6.45201273574803E-11  -3.90395991397342E-18
      1.16412808016913E-06
      0.00000000000000E+00  -6.12604397174203E-14   0.00000000000000E+00   3.95624071010191E-17   7.96782367253279E-23
      6.13062413960377E-11   6.13062809585244E-11  -1.31452505419899E-18  -4.44684505870880E-03  -4.44684505871446E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66780722071990E-12   0.00000000000000E+00   5.66780722071990E-12
      5.24767894623502E-18  -2.82861322581259E-01  -2.82840223350013E-01   0.00000000000000E+00  -1.16113286390438E-13
     -1.19637042337869E-22  -6.68579748927343E-11  -6.69740881792443E-11  -3.93315389203603E-18
      1.16912808016913E-06
      0.00000000000000E+00  -6.41994713080612E-14   0.00000000000000E+00   4.20467534404811E-17   8.34439021019956E-23
      6.42101399731001E-11   6.42101820199370E-11  -1.31352435108425E-18  -4.28993466131963E-03  -4.28993466132495E-03
      0.00000000000000E+00   0.00000000000000E+00   5.32384935204539E-12   0.00000000000000E+00   5.32384935204539E-12
      5.27429819299525E-18  -2.97402102853370E-01  -2.97380197263786E-01   0.00000000000000E+00  -1.11956824046847E-13
     -1.20981126715922E-22  -6.94220745478143E-11  -6.95340313719821E-11  -3.96077384191099E-18
      1.17412808016913E-06
      0.00000000000000E+00  -6.72303476359096E-14   0.00000000000000E+00   4.50768852488296E-17   8.64720703311461E-23
      6.72111133352536E-11   6.72111584122253E-11  -1.31236991710491E-18  -4.22444322939967E-03  -4.22444322940467E-03
      0.00000000000000E+00   0.00000000000000E+00   5.00224464070672E-12   0.00000000000000E+00   5.00224464070672E-12
      5.29930941619878E-18  -3.11255256225037E-01  -3.11232506656728E-01   0.00000000000000E+00  -1.08181283124253E-13
     -1.22265387707934E-22  -7.21052217696859E-11  -7.22134030529324E-11  -3.98693949909388E-18
      1.17912808016913E-06
      0.00000000000000E+00  -7.03530687009655E-14   0.00000000000000E+00   4.95089066188860E-17   8.91306519424194E-23
      7.03746143492083E-11   7.03746638582040E-11  -1.31101581609410E-18  -4.26769992760711E-03  -4.26769992761180E-03
      0.00000000000000E+00   0.00000000000000E+00   4.68958686127859E-12   0.00000000000000E+00   4.68958686127859E-12
      5.32275735050517E-18  -3.24494479067839E-01  -3.24470831504099E-01   0.00000000000000E+00  -1.04815997172314E-13
     -1.23496463174861E-22  -7.49594347221867E-11  -7.50642507194825E-11  -4.01174153441108E-18
      1.18412808016913E-06
      0.00000000000000E+00  -7.38431687148515E-14   0.00000000000000E+00   5.68952914379188E-17   9.16607248841478E-23
      7.38280425631091E-11   7.38280994584922E-11  -1.30935102808291E-18  -4.46740910400699E-03  -4.46740910401133E-03
      0.00000000000000E+00   0.00000000000000E+00   4.33921877032445E-12   0.00000000000000E+00   4.33921877032445E-12
      5.34445344435680E-18  -3.37134245776395E-01  -3.37109620764946E-01   0.00000000000000E+00  -1.01062751298156E-13
     -1.24671050728876E-22  -7.80662554773939E-11  -7.81673182288167E-11  -4.03510241627388E-18
      1.18912808016913E-06
      0.00000000000000E+00  -7.78843371519827E-14   0.00000000000000E+00   7.14545441170588E-17   9.43178225459526E-23
      7.78848234285780E-11   7.78848948832164E-11  -1.30710410220095E-18  -4.94146978953944E-03  -4.94146978954333E-03
      0.00000000000000E+00   0.00000000000000E+00   3.88746962395815E-12   0.00000000000000E+00   3.88746962395815E-12
      5.36389079247659E-18  -3.49175474152746E-01  -3.49149713561195E-01   0.00000000000000E+00  -9.61378288537086E-14
     -1.25776849176510E-22  -8.16762266781950E-11  -8.17723645071744E-11  -4.05678669027564E-18
      1.19412808016913E-06
      0.00000000000000E+00  -8.33950213844343E-14   0.00000000000000E+00   1.06705231743765E-16   9.75903108656744E-23
      8.33881935683248E-11   8.33883002736542E-11  -1.30358133745271E-18  -5.99019374103930E-03  -5.99019374104248E-03
      0.00000000000000E+00   0.00000000000000E+00   3.18623724848611E-12   0.00000000000000E+00   3.18623724848611E-12
      5.37982197871902E-18  -3.60629200972020E-01  -3.60601927680017E-01   0.00000000000000E+00  -8.83613572308462E-14
     -1.26782563222225E-22  -8.64861761647829E-11  -8.65745375221406E-11  -4.07624064126631E-18
      1.19912808016913E-06
      0.00000000000000E+00  -9.27631845796020E-14   0.00000000000000E+00   1.88869125695078E-16   1.02688291583157E-22
      9.27664122849063E-11   9.27666011541347E-11  -1.29695261677657E-18  -8.40243104896931E-03  -8.40243104897113E-03
      0.00000000000000E+00   0.00000000000000E+00   1.82658551567643E-12   0.00000000000000E+00   1.82658551567643E-12
      5.38895490629740E-18  -3.71504037811175E-01  -3.71474238553146E-01   0.00000000000000E+00  -7.28931985486940E-14
     -1.27602686566456E-22  -9.45202934711350E-11  -9.45931866698113E-11  -4.09200228952083E-18
      1.20412808016913E-06
      0.00000000000000E+00  -1.13060871502465E-13   0.00000000000000E+00   4.03098900317984E-16   1.12372736916946E-22
      1.13097749751746E-10   1.13098152850759E-10  -1.28276266155020E-18  -1.40709538591170E-02  -1.40709538591159E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.14972067556827E-12   0.00000000000000E+00  -1.14972067556827E-12
      5.38320630291956E-18  -3.81781874933528E-01  -3.81746608457052E-01   0.00000000000000E+00  -3.88140261519098E-14
     -1.28029306634098E-22  -1.11909618148911E-10  -1.11948432175191E-10  -4.10044364136936E-18
      1.20912808016913E-06
      0.00000000000000E+00  -1.62657029594530E-13   0.00000000000000E+00   8.86263487675117E-16   1.29978902455462E-22
      1.62650406034250E-10   1.62651292297868E-10  -1.25358219712634E-18  -2.60210977323099E-02  -2.60210977323030E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.90057376983544E-12   0.00000000000000E+00  -6.90057376983544E-12
      5.34870343407038E-18  -3.91365403534650E-01  -3.91316338341359E-01   0.00000000000000E+00   2.37502362762334E-14
     -1.27743104395965E-22  -1.55774468764180E-10  -1.55750718528032E-10  -4.09512123694405E-18
      1.21412808016913E-06
      0.00000000000000E+00  -2.75809745834203E-13   0.00000000000000E+00   1.69836073920204E-15   1.52333813909241E-22
      2.75857836732588E-10   2.75859535093479E-10  -1.20645518603551E-18  -4.51813251476879E-02  -4.51813251476737E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.41658825012642E-11   0.00000000000000E+00  -1.41658825012642E-11
      5.27787402156406E-18  -3.99993538567566E-01  -3.99911098591898E-01   0.00000000000000E+00   9.00877469846543E-14
     -1.26697752705326E-22  -2.61783740339073E-10  -2.61693652592215E-10  -4.07141883552855E-18
      1.21912808016913E-06
      0.00000000000000E+00  -5.00645662518228E-13   0.00000000000000E+00   2.84581207829280E-15   1.70962669770992E-22
      5.00616088844403E-10   5.00618934656652E-10  -1.14917734602446E-18  -6.83838914097343E-02  -6.83838914097146E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.96618541495486E-11   0.00000000000000E+00  -1.96618541495486E-11
      5.17956475081632E-18  -4.07175898738612E-01  -4.07024384514888E-01   0.00000000000000E+00   1.22042702597602E-13
     -1.25272050008789E-22  -4.81079123209575E-10  -4.80957080507103E-10  -4.03038740479186E-18
      1.22412808016913E-06
      0.00000000000000E+00  -8.96863858831499E-13   0.00000000000000E+00   4.53402298703296E-15   1.84345101256138E-22
      8.96837785771585E-10   8.96842319794756E-10  -1.09122801042644E-18  -9.24696582489825E-02  -9.24696582489594E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.30584491447682E-11   0.00000000000000E+00  -2.30584491447682E-11
      5.06427250509248E-18  -4.12160815177228E-01  -4.11885548438936E-01   0.00000000000000E+00   1.29279362013963E-13
     -1.23733165746385E-22  -8.73913150011878E-10  -8.73783870649988E-10  -3.97304449466604E-18
      1.22912808016913E-06
      0.00000000000000E+00  -1.52664322186351E-12   0.00000000000000E+00   6.72947010108155E-15   1.94574726133371E-22
      1.52666730750699E-09   1.52667403697729E-09  -1.03767085452715E-18  -1.15998514337526E-01  -1.15998514337500E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.56954211475773E-11   0.00000000000000E+00  -2.56954211475773E-11
      4.93579539935459E-18  -4.13944881200971E-01  -4.13472027368988E-01   0.00000000000000E+00   1.33143255758504E-13
     -1.22108429793773E-22  -1.50111175908535E-09  -1.50097861582971E-09  -3.89812454482744E-18
      1.23412808016913E-06
      0.00000000000000E+00  -2.43912068602029E-12   0.00000000000000E+00   9.45143556761382E-15   2.02582755663513E-22
      2.43915596419479E-09   2.43916541563056E-09  -9.89755401342840E-19  -1.38572099281530E-01  -1.38572099281501E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.84337471058737E-11   0.00000000000000E+00  -2.84337471058737E-11
      4.79362666382522E-18  -4.11343993072979E-01  -4.10584534453542E-01   0.00000000000000E+00   1.43574914863879E-13
     -1.20306450372849E-22  -2.41087524343942E-09  -2.41073166852468E-09  -3.80387126248238E-18
      1.23912808016913E-06
      0.00000000000000E+00  -3.65477762769911E-12   0.00000000000000E+00   1.23835424504431E-14   2.07989778366339E-22
      3.65478709321167E-09   3.65479947675433E-09  -9.47062236558659E-19  -1.60112854989577E-01  -1.60112854989546E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.13230621313115E-11   0.00000000000000E+00  -3.13230621313115E-11
      4.63701135316867E-18  -4.03132230335120E-01  -4.01990709423363E-01   0.00000000000000E+00   1.63455694708635E-13
     -1.18194991430370E-22  -3.62363987031761E-09  -3.62347641462302E-09  -3.68994911661001E-18
      1.24412808016913E-06
      0.00000000000000E+00  -5.16296005738391E-12   0.00000000000000E+00   1.37575498585116E-14   2.10105790555263E-22
      5.16290381313040E-09   5.16291757068047E-09  -9.08693961392431E-19  -1.80627861988300E-01  -1.80627861988265E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.40852180779403E-11   0.00000000000000E+00  -3.40852180779403E-11
      4.46658526277896E-18  -3.88188634126136E-01  -3.86572859425854E-01   0.00000000000000E+00   1.94525261874997E-13
     -1.15624204360537E-22  -5.12902687786430E-09  -5.12883235260254E-09  -3.55789130138654E-18
      1.24912808016913E-06
      0.00000000000000E+00  -6.93042018020555E-12   0.00000000000000E+00   1.77393724535472E-14   2.08606260682786E-22
      6.93036010543155E-09   6.93037784480421E-09  -8.73752746585740E-19  -2.00153192758583E-01  -2.00153192758547E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.64477364266460E-11   0.00000000000000E+00  -3.64477364266460E-11
      4.28434658064574E-18  -3.65599071218108E-01  -3.63427202732334E-01   0.00000000000000E+00   2.30380801074514E-13
     -1.12440644534051E-22  -6.89416048917853E-09  -6.89393010837757E-09  -3.41059383405999E-18
      1.25412808016913E-06
      0.00000000000000E+00  -8.90903135386730E-12   0.00000000000000E+00   1.97922903867267E-14   2.03957333320458E-22
      8.90903961650333E-09   8.90905940879392E-09  -8.41497597775105E-19  -2.18733350689754E-01  -2.18733350689715E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.82672456264842E-11   0.00000000000000E+00  -3.82672456264842E-11
      4.09301035251331E-18  -3.34722595219971E-01  -3.31927900618867E-01   0.00000000000000E+00   2.70322345819491E-13
     -1.08497032847654E-22  -8.87106248551315E-09  -8.87079216316744E-09  -3.25151275473821E-18
      1.25912808016913E-06
      0.00000000000000E+00  -1.10279812859822E-11   0.00000000000000E+00   2.11511497695263E-14   1.97319833793138E-22
      1.10279192511819E-08   1.10279404023318E-08  -8.11386110813608E-19  -2.36413226926347E-01  -2.36413226926307E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.96292112747406E-11   0.00000000000000E+00  -3.96292112747406E-11
      3.89486429613961E-18  -2.95297906356837E-01  -2.91836050592439E-01   0.00000000000000E+00   3.01620401981126E-13
     -1.03639736958696E-22  -1.09886128114590E-08  -1.09883111910571E-08  -3.08347818532600E-18
      1.26412808016913E-06
      0.00000000000000E+00  -1.31439003417692E-11   0.00000000000000E+00   2.11022459371131E-14   1.88642471747345E-22
      1.31438920592958E-08   1.31439131615419E-08  -7.83132330463972E-19  -2.53233991392434E-01  -2.53233991392392E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.10753053919233E-11   0.00000000000000E+00  -4.10753053919233E-11
      3.68948776917999E-18  -2.47763824043234E-01  -2.43635728196174E-01   0.00000000000000E+00   3.05167451364045E-13
     -9.77148388980167E-23  -1.31031430236013E-08  -1.31028378561500E-08  -2.90635543871602E-18
      1.26912808016913E-06
      0.00000000000000E+00  -1.49637119647991E-11   0.00000000000000E+00   1.81602553470271E-14   1.72133931504324E-22
      1.49637079851638E-08   1.49637261454193E-08  -7.56770737842811E-19  -2.69230165916347E-01  -2.69230165916303E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.36885486815164E-11   0.00000000000000E+00  -4.36885486815164E-11
      3.47104502577241E-18  -1.93901510155980E-01  -1.89200837199602E-01   0.00000000000000E+00   2.65240299442621E-13
     -9.10697893142540E-23  -1.49203028370372E-08  -1.49200375967378E-08  -2.71427428792960E-18
      1.27412808016913E-06
      0.00000000000000E+00  -1.62037077618379E-11   0.00000000000000E+00   1.24184919957229E-14   1.40967465864851E-22
      1.62037348011976E-08   1.62037472196897E-08  -7.32273012770929E-19  -2.84437724627623E-01  -2.84437724627576E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.68704197582589E-11   0.00000000000000E+00  -4.68704197582589E-11
      3.23669292698112E-18  -1.36719974548716E-01  -1.31629574605210E-01   0.00000000000000E+00   2.03576554580706E-13
     -8.52671237641751E-23  -1.61570803764860E-08  -1.61568767999315E-08  -2.50441991421019E-18
      1.27912808016913E-06
      0.00000000000000E+00  -1.64632609891864E-11   0.00000000000000E+00   2.73778056715030E-15   9.58050227001188E-23
      1.64633231836984E-08   1.64633259214790E-08  -7.09364187036618E-19  -2.98902014910580E-01  -2.98902014910531E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83101257244004E-11   0.00000000000000E+00  -4.83101257244004E-11
      2.99514229835911E-18  -8.09860591213899E-02  -7.58142903166834E-02   0.00000000000000E+00   1.55329367913382E-13
     -7.54549712372592E-23  -1.64151711251225E-08  -1.64150157957546E-08  -2.28577811132250E-18
      1.28412808016913E-06
      0.00000000000000E+00  -1.40029241688712E-11   0.00000000000000E+00  -2.41829704251302E-14   4.68522042545175E-23
      1.40029187614119E-08   1.40028945784415E-08  -6.86590461031384E-19  -3.12687361808189E-01  -3.12687361808146E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.35503753829632E-11   0.00000000000000E+00  -4.35503753829632E-11
      2.77739042144430E-18  -3.94980545263008E-02  -3.50999559411328E-02   0.00000000000000E+00   1.21203641284263E-13
     -4.50690193229654E-23  -1.39594654066998E-08  -1.39593442030586E-08  -2.09079996041291E-18
      1.28912808016913E-06
      0.00000000000000E+00  -9.91684365524549E-12   0.00000000000000E+00  -4.01580410390786E-14   2.09087926741335E-23
      9.91682763036761E-09   9.91678747232659E-09  -6.60994167311102E-19  -3.25863133922637E-01  -3.25863133922606E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.08353192599599E-11   0.00000000000000E+00  -3.08353192599599E-11
      2.62321382514450E-18  -1.92693035035835E-02  -1.61545795521837E-02   0.00000000000000E+00   8.84252387022200E-14
     -2.09543005162800E-23  -9.88604057830531E-09  -9.88595215306663E-09  -1.96221965783340E-18
      1.29412808016913E-06
      0.00000000000000E+00  -7.48681559820875E-12   0.00000000000000E+00  -2.38101770192978E-14   1.11916676045473E-23
      7.48679161395685E-09   7.48676780377984E-09  -6.33591890697040E-19  -3.38439189233207E-01  -3.38439189233185E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.18783096125327E-11   0.00000000000000E+00  -2.18783096125327E-11
      2.51382227708184E-18  -1.14648584470433E-02  -9.11292476608651E-03   0.00000000000000E+00   5.03131332462181E-14
     -1.18655470316410E-23  -7.46493980730055E-09  -7.46488949416732E-09  -1.88023038638479E-18
      1.29912808016913E-06
      0.00000000000000E+00  -6.55688763398254E-12   0.00000000000000E+00  -9.00511357308027E-15   7.44266062501942E-24
      6.55689209662102E-09   6.55688309150745E-09  -6.06008308345860E-19  -3.50417503795740E-01  -3.50417503795722E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79565794811169E-11   0.00000000000000E+00  -1.79565794811169E-11
      2.42403937967625E-18  -8.41034965117608E-03  -6.35015341792910E-03   0.00000000000000E+00   2.75187978413112E-14
     -8.43606852397178E-24  -6.53895403082417E-09  -6.53892651202633E-09  -1.81803107133039E-18
      1.30412808016913E-06
      0.00000000000000E+00  -6.24985067749778E-12   0.00000000000000E+00  -2.89349959540701E-15   5.63763304241800E-24
      6.24983637422270E-09   6.24983348072311E-09  -5.78969066599804E-19  -3.61809656054907E-01  -3.61809656054891E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.62585274741077E-11   0.00000000000000E+00  -1.62585274741077E-11
      2.34274674230571E-18  -6.94156867221443E-03  -4.97757681031451E-03   0.00000000000000E+00   1.79964246932785E-14
     -6.69986981290272E-24  -6.23359294967369E-09  -6.23357495324901E-09  -1.76377767570591E-18
      1.30912808016913E-06
      0.00000000000000E+00  -6.14092281916965E-12   0.00000000000000E+00  -9.52354519222960E-16   4.54687646817224E-24
      6.14091256078237E-09   6.14091160842785E-09  -5.52795154259378E-19  -3.72622857391268E-01  -3.72622857391252E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53151161007241E-11   0.00000000000000E+00  -1.53151161007241E-11
      2.26617116180209E-18  -6.05012455777519E-03  -4.12015170520382E-03   0.00000000000000E+00   1.40156099409791E-14
     -5.58045484073009E-24  -6.12561050793707E-09  -6.12559649232714E-09  -1.71337600754271E-18
      1.31412808016913E-06
      0.00000000000000E+00  -6.09105112686597E-12   0.00000000000000E+00  -3.82214135783606E-16   3.80193814478943E-24
      6.09103381601004E-09   6.09103343379591E-09  -5.27746905750845E-19  -3.82833811817123E-01  -3.82833811817108E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45900584359248E-11   0.00000000000000E+00  -1.45900584359248E-11
      2.19322086962247E-18  -5.43125946505131E-03  -3.51677190470188E-03   0.00000000000000E+00   1.18508707710535E-14
     -4.77179481083529E-24  -6.07645522623075E-09  -6.07644337535998E-09  -1.66547396387162E-18
      1.31912808016913E-06
      0.00000000000000E+00  -6.06083420832469E-12   0.00000000000000E+00  -2.00756812276613E-16   3.26821297013269E-24
      6.06081383731103E-09   6.06081363655422E-09  -5.04245238349091E-19  -3.92332029316449E-01  -3.92332029316435E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37922170099048E-11   0.00000000000000E+00  -1.37922170099048E-11
      2.12425978457294E-18  -4.97929560278200E-03  -3.07407686790199E-03   0.00000000000000E+00   1.02055379076089E-14
     -4.16741823614101E-24  -6.04703162508222E-09  -6.04702141954432E-09  -1.62001454622385E-18
      1.32412808016913E-06
      0.00000000000000E+00  -6.03824040297164E-12   0.00000000000000E+00  -1.38501132505469E-16   2.88217072378952E-24
      6.03827722011123E-09   6.03827708161010E-09  -4.83104117202400E-19  -4.00834526518603E-01  -4.00834526518590E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.25843553250108E-11   0.00000000000000E+00  -1.25843553250108E-11
      2.06133800794789E-18  -4.64834025582598E-03  -2.74984059636346E-03   0.00000000000000E+00   8.59442195769011E-15
     -3.72258915726480E-24  -6.02570132070704E-09  -6.02569272628509E-09  -1.57823389074549E-18
      1.32912808016913E-06
      0.00000000000000E+00  -6.01849378447202E-12   0.00000000000000E+00  -1.25117215171295E-16   2.61033134399216E-24
      6.01847095661343E-09   6.01847083149622E-09  -4.65687634228431E-19  -4.07824222628879E-01  -4.07824222628868E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05417636697101E-11   0.00000000000000E+00  -1.05417636697101E-11
      2.00862918959934E-18  -4.41595324302674E-03  -2.52304963094486E-03   0.00000000000000E+00   6.74039913401943E-15
     -3.41787977280674E-24  -6.00793580822564E-09  -6.00792906782651E-09  -1.54294155537091E-18
      1.33412808016913E-06
      0.00000000000000E+00  -5.99828794228636E-12   0.00000000000000E+00  -1.07520810304272E-16   2.43621265194574E-24
      5.99829055947863E-09   5.99829045195783E-09  -4.53978565050761E-19  -4.12521360179724E-01  -4.12521360179716E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19460704842090E-12   0.00000000000000E+00  -7.19460704842090E-12
      1.97265615435723E-18  -4.27317209664306E-03  -2.38557164866792E-03   0.00000000000000E+00   4.37962698497578E-15
     -3.25110625624631E-24  -5.99110022453639E-09  -5.99109584490941E-09  -1.51867758930647E-18
      1.33912808016913E-06
      0.00000000000000E+00  -5.97486753429845E-12   0.00000000000000E+00  -2.18886046388924E-16   2.35609401345821E-24
      5.97483296016028E-09   5.97483274127424E-09  -4.50545174135643E-19  -4.13898729743086E-01  -4.13898729743084E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.13338615543786E-12   0.00000000000000E+00  -2.13338615543786E-12
      1.96198922358004E-18  -4.22327571263052E-03  -2.34147125490864E-03   0.00000000000000E+00   1.41383432845629E-15
     -3.24124655774562E-24  -5.97270076895313E-09  -5.97269935511880E-09  -1.51144404944440E-18
      1.34412808016913E-06
      0.00000000000000E+00  -5.94419139207113E-12   0.00000000000000E+00  -3.30424722420982E-16   2.38009556485882E-24
      5.94418812652378E-09   5.94418779609906E-09  -4.58367503205229E-19  -4.10760384408965E-01  -4.10760384408970E-01
      0.00000000000000E+00   0.00000000000000E+00   4.81704511957710E-12   0.00000000000000E+00   4.81704511957710E-12
      1.98607444917793E-18  -4.28708592515831E-03  -2.41274713020382E-03   0.00000000000000E+00  -2.56085546987268E-15
     -3.44563558048035E-24  -5.94900228036316E-09  -5.94900484121863E-09  -1.52770694597270E-18
      1.34912808016913E-06
      0.00000000000000E+00  -5.89909562610224E-12   0.00000000000000E+00  -5.26847616340812E-16   2.53897184138393E-24
      5.89912757486666E-09   5.89912704801904E-09  -4.80490524257501E-19  -4.01885137849757E-01  -4.01885137849770E-01
      0.00000000000000E+00   0.00000000000000E+00   1.34198409663426E-11   0.00000000000000E+00   1.34198409663426E-11
      2.05317365400964E-18  -4.51974608600894E-03  -2.65689486546777E-03   0.00000000000000E+00  -7.84914576145317E-15
     -4.00835949723857E-24  -5.91253903983962E-09  -5.91254688898539E-09  -1.57268312975214E-18
      1.35412808016913E-06
      0.00000000000000E+00  -5.82258896000837E-12   0.00000000000000E+00  -9.10267580853926E-16   2.89968662131762E-24
      5.82260193550943E-09   5.82260102524185E-09  -5.19535785807649E-19  -3.86170044127194E-01  -3.86170044127217E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30481136535072E-11   0.00000000000000E+00   2.30481136535072E-11
      2.16841422227718E-18  -5.05761376086070E-03  -3.21584146165256E-03   0.00000000000000E+00  -1.50119104458340E-14
     -5.30175054266739E-24  -5.84563412698491E-09  -5.84564913889536E-09  -1.64887843646953E-18
      1.35912808016913E-06
      0.00000000000000E+00  -5.66884086992297E-12   0.00000000000000E+00  -1.77171102278784E-15   3.59020215633626E-24
      5.66883360904508E-09   5.66883183733407E-09  -5.76913869638087E-19  -3.62726961762193E-01  -3.62726961762226E-01
      0.00000000000000E+00   0.00000000000000E+00   3.30894926005937E-11   0.00000000000000E+00   3.30894926005937E-11
      2.33386168528015E-18  -6.25062952123336E-03  -4.45414379205089E-03   0.00000000000000E+00  -2.49595731797044E-14
     -8.34564096613386E-24  -5.70189637036147E-09  -5.70192132993466E-09  -1.75694781564206E-18
      1.36412808016913E-06
      0.00000000000000E+00  -5.31432018430191E-12   0.00000000000000E+00  -3.88482908843122E-15   4.79242019802933E-24
      5.31433751796466E-09   5.31433363313558E-09  -6.51491162237586E-19  -3.30948279516738E-01  -3.30948279516782E-01
      0.00000000000000E+00   0.00000000000000E+00   4.39763484345763E-11   0.00000000000000E+00   4.39763484345763E-11
      2.55374342745303E-18  -9.01576912525117E-03  -7.32754783703833E-03   0.00000000000000E+00  -3.89582108984526E-14
     -1.58630864623265E-23  -5.35827102335924E-09  -5.35830998157016E-09  -1.90225226521544E-18
      1.36912808016913E-06
      0.00000000000000E+00  -4.49359561261545E-12   0.00000000000000E+00  -8.64642790991721E-15   6.41413707437205E-24
      4.49361823325331E-09   4.49360958682540E-09  -7.38748926211816E-19  -2.90625715834388E-01  -2.90625715834446E-01
      0.00000000000000E+00   0.00000000000000E+00   5.80676085758904E-11   0.00000000000000E+00   5.80676085758904E-11
      2.84408147033248E-18  -1.54743503869747E-02  -1.40402767422302E-02   0.00000000000000E+00  -5.86519509705607E-14
     -3.30024276894558E-23  -4.55161854345029E-09  -4.55167719540129E-09  -2.10533254412066E-18
      1.37412808016913E-06
      0.00000000000000E+00  -2.99808775666530E-12   0.00000000000000E+00  -1.54918835123518E-14   6.27203872173441E-24
      2.99816981834288E-09   2.99815432645937E-09  -8.34015421041943E-19  -2.42307424718847E-01  -2.42307424718922E-01
      0.00000000000000E+00   0.00000000000000E+00   7.54483435626068E-11   0.00000000000000E+00   7.54483435626068E-11
      3.22132318814552E-18  -2.86343853780493E-02  -2.76660061253381E-02   0.00000000000000E+00  -8.81934500835016E-14
     -6.00221550780563E-23  -3.07351447657184E-09  -3.07360267002198E-09  -2.38730776710357E-18
      1.37912808016913E-06
      0.00000000000000E+00  -1.39686660818927E-12   0.00000000000000E+00  -1.69080776532839E-14  -1.57579200176293E-24
      1.39683909121228E-09   1.39682218313463E-09  -9.37273168405897E-19  -1.87939922404074E-01  -1.87939922404162E-01
      0.00000000000000E+00   0.00000000000000E+00   8.72894546610355E-11   0.00000000000000E+00   8.72894546610355E-11
      3.65777046145069E-18  -4.87026413797756E-02  -4.82350556021974E-02   0.00000000000000E+00  -1.35423404700738E-13
     -8.13823460498876E-23  -1.48397621439088E-09  -1.48411163779566E-09  -2.72049729304480E-18
      1.38412808016913E-06
      0.00000000000000E+00  -4.68775538707217E-13   0.00000000000000E+00  -1.03123944823265E-14  -1.70561025494111E-23
      4.68768141391988E-10   4.68757828997489E-10  -1.05031795176826E-18  -1.30614537863578E-01  -1.30614537863666E-01
      0.00000000000000E+00   0.00000000000000E+00   8.72368985177249E-11   0.00000000000000E+00   8.72368985177249E-11
      4.09395495403932E-18  -7.22105869498506E-02  -7.20354161963964E-02   0.00000000000000E+00  -2.01871300966495E-13
     -9.06607948485339E-23  -5.55792856214157E-10  -5.55994727515214E-10  -3.04363700227105E-18
      1.38912808016913E-06
      0.00000000000000E+00  -1.26378358397557E-13   0.00000000000000E+00  -4.70276878638002E-15  -3.07431791664997E-23
      1.26338243325749E-10   1.26333540556932E-10  -1.16578414892660E-18  -7.56105607607494E-02  -7.56105607608258E-02
      0.00000000000000E+00   0.00000000000000E+00   7.64033315223680E-11   0.00000000000000E+00   7.64033315223680E-11
      4.47597161165116E-18  -9.62661181622665E-02  -9.62022447381275E-02   0.00000000000000E+00  -2.74334312767920E-13
     -9.67311285563764E-23  -2.02462537766435E-10  -2.02736872079299E-10  -3.31018746272456E-18
      1.39412808016913E-06
      0.00000000000000E+00  -4.53713001805182E-14   0.00000000000000E+00  -1.81319941488873E-15  -3.50958615453505E-23
      4.54367708648027E-11   4.54349576653528E-11  -1.25132219478173E-18  -3.64385078587306E-02  -3.64385078587846E-02
      0.00000000000000E+00   0.00000000000000E+00   5.39795967261919E-11   0.00000000000000E+00   5.39795967261919E-11
      4.74586959528212E-18  -1.19655685455135E-01  -1.19624364521525E-01   0.00000000000000E+00  -2.79446722522741E-13
     -1.02044038805744E-22  -9.91351076689198E-11  -9.94145543915446E-11  -3.49454740050039E-18
      1.39912808016913E-06
      0.00000000000000E+00  -3.72889633062559E-14   0.00000000000000E+00  -5.12239666618127E-16  -3.06999089595521E-23
      3.73141377485307E-11   3.73136255088334E-11  -1.29297639627979E-18  -1.80322938449585E-02  -1.80322938449894E-02
      0.00000000000000E+00   0.00000000000000E+00   3.08861803514093E-11   0.00000000000000E+00   3.08861803514093E-11
      4.90030049703916E-18  -1.42066897306134E-01  -1.42045410871867E-01   0.00000000000000E+00  -2.11060549810916E-13
     -1.05627039185678E-22  -6.79887453103262E-11  -6.81998058602428E-11  -3.60732410075937E-18
      1.40412808016913E-06
      0.00000000000000E+00  -4.08709080573494E-14   0.00000000000000E+00  -9.04564594816081E-17  -1.79185915780539E-23
      4.09081462335042E-11   4.09080557770268E-11  -1.30897037936175E-18  -1.10004493505803E-02  -1.10004493505980E-02
      0.00000000000000E+00   0.00000000000000E+00   1.76764272090647E-11   0.00000000000000E+00   1.76764272090647E-11
      4.98868263308449E-18  -1.63442934003652E-01  -1.63424477039799E-01   0.00000000000000E+00  -1.62573929282539E-13
     -1.08158033979739E-22  -5.84219090567007E-11  -5.85844829860914E-11  -3.67971225372274E-18
      1.40912808016913E-06
      0.00000000000000E+00  -4.48202317572731E-14   0.00000000000000E+00   1.70335087402256E-17   2.53543129042021E-24
      4.48564393916032E-11   4.48564564251145E-11  -1.31450223188508E-18  -8.20759705464409E-03  -8.20759705465579E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17029522585296E-11   0.00000000000000E+00   1.17029522585296E-11
      5.04719739437714E-18  -1.83797781725071E-01  -1.83779962888379E-01   0.00000000000000E+00  -1.43872980656362E-13
     -1.10266013122736E-22  -5.64155357028776E-11  -5.65594086836442E-11  -3.73269516249206E-18
      1.41412808016913E-06
      0.00000000000000E+00  -4.81266422967440E-14   0.00000000000000E+00   3.24975424454150E-17   2.52379251961944E-23
      4.80942113951464E-11   4.80942438927141E-11  -1.31626992690142E-18  -6.82805708785922E-03  -6.82805708786826E-03
      0.00000000000000E+00   0.00000000000000E+00   9.03611509291858E-12   0.00000000000000E+00   9.03611509291858E-12
      5.09237796984173E-18  -2.03169768432278E-01  -2.03151769835646E-01   0.00000000000000E+00  -1.36896341725123E-13
     -1.12173244012419E-22  -5.69934626437956E-11  -5.71303589856329E-11  -3.77610804294030E-18
      1.41912808016913E-06
      0.00000000000000E+00  -5.09738291501773E-14   0.00000000000000E+00   3.28764093248063E-17   4.48507505826734E-23
      5.09431149283023E-11   5.09431478047565E-11  -1.31665004241976E-18  -5.97429666733059E-03  -5.97429666733829E-03
      0.00000000000000E+00   0.00000000000000E+00   7.70145909643476E-12   0.00000000000000E+00   7.70145909643476E-12
      5.13088526532390E-18  -2.21603816955101E-01  -2.21585341415299E-01   0.00000000000000E+00  -1.32498277412262E-13
     -1.13939646088205E-22  -5.85121086236647E-11  -5.86446069011909E-11  -3.81423522290414E-18
      1.42412808016913E-06
      0.00000000000000E+00  -5.36373265291956E-14   0.00000000000000E+00   3.36153461452283E-17   5.94349623632057E-23
      5.36787689525034E-11   5.36788025679090E-11  -1.31643518609739E-18  -5.37653019516141E-03  -5.37653019516833E-03
      0.00000000000000E+00   0.00000000000000E+00   6.91431993341375E-12   0.00000000000000E+00   6.91431993341375E-12
      5.16545686499097E-18  -2.39144476484810E-01  -2.39125387192352E-01   0.00000000000000E+00  -1.28228115692527E-13
     -1.15589061152646E-22  -6.04648943855147E-11  -6.05931225013229E-11  -3.84902167889358E-18
      1.42912808016913E-06
      0.00000000000000E+00  -5.63926686454214E-14   0.00000000000000E+00   3.55305381486613E-17   6.94043353874579E-23
      5.64236561000670E-11   5.64236916306745E-11  -1.31590438465828E-18  -4.93900710205255E-03  -4.93900710205892E-03
      0.00000000000000E+00   0.00000000000000E+00   6.37094117112212E-12   0.00000000000000E+00   6.37094117112212E-12
      5.19731157084658E-18  -2.55831975855208E-01  -2.55812193111581E-01   0.00000000000000E+00  -1.23801196036903E-13
     -1.17139894508906E-22  -6.26708316056425E-11  -6.27946328017965E-11  -3.88140718618830E-18
      1.43412808016913E-06
      0.00000000000000E+00  -5.92398554988548E-14   0.00000000000000E+00   3.78298605480000E-17   7.61003682684242E-23
      5.92163904088504E-11   5.92164282387871E-11  -1.31516832230558E-18  -4.61928860768778E-03  -4.61928860769373E-03
      0.00000000000000E+00   0.00000000000000E+00   5.94310685723526E-12   0.00000000000000E+00   5.94310685723526E-12
      5.22702710513276E-18  -2.71700033670989E-01  -2.71679506006619E-01   0.00000000000000E+00  -1.19328865025530E-13
     -1.18606574634374E-22  -6.50402062308782E-11  -6.51595350960224E-11  -3.91185878282717E-18
      1.43912808016913E-06
      0.00000000000000E+00  -6.20870423522881E-14   0.00000000000000E+00   4.01962203357463E-17   8.07769247803483E-23
      6.20685430550627E-11   6.20685832513638E-11  -1.31427383627588E-18  -4.39662234175350E-03  -4.39662234175908E-03
      0.00000000000000E+00   0.00000000000000E+00   5.57393175789648E-12   0.00000000000000E+00   5.57393175789648E-12
      5.25489676392224E-18  -2.86786296170344E-01  -2.86764986390930E-01   0.00000000000000E+00  -1.14985529771558E-13
     -1.19999573820483E-22  -6.75275294793689E-11  -6.76425150092605E-11  -3.94062292764636E-18
      1.44412808016913E-06
      0.00000000000000E+00  -6.50260739429289E-14   0.00000000000000E+00   4.27672015140448E-17   8.42999049545310E-23
      6.49940434612342E-11   6.49940862285200E-11  -1.31323451578016E-18  -4.26329554396974E-03  -4.26329554397497E-03
      0.00000000000000E+00   0.00000000000000E+00   5.23654109148808E-12   0.00000000000000E+00   5.23654109148808E-12
      5.28107946937968E-18  -3.01137165943890E-01  -3.01115040932884E-01   0.00000000000000E+00  -1.10905441319660E-13
     -1.21326963915046E-22  -7.01197218785670E-11  -7.02306273200080E-11  -3.96784495359952E-18
      1.44912808016913E-06
      0.00000000000000E+00  -6.80569502707773E-14   0.00000000000000E+00   4.60740561721010E-17   8.72015799117267E-23
      6.80301348113353E-11   6.80301808854787E-11  -1.31203347770949E-18  -4.22406502392367E-03  -4.22406502392858E-03
      0.00000000000000E+00   0.00000000000000E+00   4.92001906105277E-12   0.00000000000000E+00   4.92001906105277E-12
      5.30567956468494E-18  -3.14822500657451E-01  -3.14799519004034E-01   0.00000000000000E+00  -1.07274392469617E-13
     -1.22596811658875E-22  -7.28429255539390E-11  -7.29501999465312E-11  -3.99364608697545E-18
      1.45412808016913E-06
      0.00000000000000E+00  -7.12715160730408E-14   0.00000000000000E+00   5.10753955183013E-17   8.98048120145613E-23
      7.12536691690127E-11   7.12537202444980E-11  -1.31061195216115E-18  -4.30229414594120E-03  -4.30229414594580E-03
      0.00000000000000E+00   0.00000000000000E+00   4.60254783552621E-12   0.00000000000000E+00   4.60254783552621E-12
      5.32869230386257E-18  -3.27903136094010E-01  -3.27879239050145E-01   0.00000000000000E+00  -1.03891636583417E-13
     -1.23813623292886E-22  -7.57523764433172E-11  -7.58562680800245E-11  -4.01808035170143E-18
      1.45912808016913E-06
      0.00000000000000E+00  -7.48534608241343E-14   0.00000000000000E+00   5.97753488154751E-17   9.23391503555474E-23
      7.48237500785691E-11   7.48238098540103E-11  -1.30882985375671E-18  -4.55867902222630E-03  -4.55867902223054E-03
      0.00000000000000E+00   0.00000000000000E+00   4.23298921825065E-12   0.00000000000000E+00   4.23298921825065E-12
      5.34985724995383E-18  -3.40383676860830E-01  -3.40358771666744E-01   0.00000000000000E+00  -9.99106719606902E-14
     -1.24971619157817E-22  -7.89568884001755E-11  -7.90567990722611E-11  -4.04102739619712E-18
      1.46412808016913E-06
      0.00000000000000E+00  -7.91701634728881E-14   0.00000000000000E+00   7.79141684264875E-17   9.50942812733684E-23
      7.91451821233056E-11   7.91452600375692E-11  -1.30634069216467E-18  -5.14355709561852E-03  -5.14355709562226E-03
      0.00000000000000E+00   0.00000000000000E+00   3.73600475600475E-12   0.00000000000000E+00   3.73600475600475E-12
      5.36853727373386E-18  -3.52267908025219E-01  -3.52241798129433E-01   0.00000000000000E+00  -9.44725818709945E-14
     -1.26055268434602E-22  -8.27867922115766E-11  -8.28812647935736E-11  -4.06219658156918E-18
      1.46912808016913E-06
      0.00000000000000E+00  -8.53237608657924E-14   0.00000000000000E+00   1.20033807414171E-16   9.86845905104312E-23
      8.53271299327654E-11   8.53272499666715E-11  -1.30224827593075E-18  -6.44461173968147E-03  -6.44461173968439E-03
      0.00000000000000E+00   0.00000000000000E+00   2.91726637394947E-12   0.00000000000000E+00   2.91726637394947E-12
      5.38312360560360E-18  -3.63567898930582E-01  -3.63540099581216E-01   0.00000000000000E+00  -8.53293472606035E-14
     -1.27023730809205E-22  -8.81591869932331E-11  -8.82445163406207E-11  -4.08087532967285E-18
      1.47412808016913E-06
      0.00000000000000E+00  -9.66206635423181E-14   0.00000000000000E+00   2.28313923696816E-16   1.04650666373589E-22
      9.66046567568586E-11   9.66048850708869E-11  -1.29419858538075E-18  -9.47410797466039E-03  -9.47410797466164E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25015577384696E-12   0.00000000000000E+00   1.25015577384696E-12
      5.38937438447284E-18  -3.74288244680044E-01  -3.74257417886939E-01   0.00000000000000E+00  -6.62728325291508E-14
     -1.27766514856471E-22  -9.77887680120774E-11  -9.78550408447343E-11  -4.09517579909209E-18
      1.47912808016913E-06
      0.00000000000000E+00  -1.22245345223218E-13   0.00000000000000E+00   5.00805497434628E-16   1.16202949429131E-22
      1.22251642070159E-10   1.22252142875773E-10  -1.27679774408860E-18  -1.65068945656511E-02  -1.65068945656487E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.38205305793435E-12   0.00000000000000E+00  -2.38205305793435E-12
      5.37746411918316E-18  -3.84396682230930E-01  -3.84358920266052E-01   0.00000000000000E+00  -2.49310091792413E-14
     -1.28034583504557E-22  -1.19845158808531E-10  -1.19870089817839E-10  -4.10066637509456E-18
      1.48412808016913E-06
      0.00000000000000E+00  -1.84699766524336E-13   0.00000000000000E+00   1.06280448952664E-15   1.35824411568988E-22
      1.84716953527460E-10   1.84718016332085E-10  -1.24266976683403E-18  -3.04800064732820E-02  -3.04800064732732E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.82780652376145E-12   0.00000000000000E+00  -8.82780652376145E-12
      5.33332508656435E-18  -3.93760993365913E-01  -3.93705583732036E-01   0.00000000000000E+00   4.31035746960638E-14
     -1.27527919911014E-22  -1.75933313382892E-10  -1.75890209808324E-10  -4.09065531973033E-18
      1.48912808016913E-06
      0.00000000000000E+00  -3.22283182861211E-13   0.00000000000000E+00   2.01459113574439E-15   1.57846579676999E-22
      3.22282585422802E-10   3.22284600014096E-10  -1.19181697786306E-18  -5.10979873789400E-02  -5.10979873789242E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.58728876446487E-11   0.00000000000000E+00  -1.58728876446487E-11
      5.25396064834111E-18  -4.02064093987391E-01  -4.01967566604049E-01   0.00000000000000E+00   1.02214463201554E-13
     -1.26340741780055E-22  -3.06513926832521E-10  -3.06411712369446E-10  -4.06214367047805E-18
      1.49412808016913E-06
      0.00000000000000E+00  -5.86336802332851E-13   0.00000000000000E+00   3.30468744660936E-15   1.74933325504282E-22
      5.86292520554822E-10   5.86295825242444E-10  -1.13358908765702E-18  -7.47679153759080E-02  -7.47679153758873E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.07143811915699E-11   0.00000000000000E+00  -2.07143811915699E-11
      5.15038874238326E-18  -4.08748231644355E-01  -4.08570058241628E-01   0.00000000000000E+00   1.25220794812891E-13
     -1.24870865243927E-22  -5.65706664845562E-10  -5.65581444050874E-10  -4.01679965472624E-18
      1.49912808016913E-06
      0.00000000000000E+00  -1.03858028834271E-12   0.00000000000000E+00   5.02947323683149E-15   1.87293825528173E-22
      1.03862111227540E-09   1.03862614174882E-09  -1.07650593577231E-18  -9.87869059333962E-02  -9.87869059333725E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.37798001384823E-11   0.00000000000000E+00  -2.37798001384823E-11
      5.03148974169085E-18  -4.12991843834905E-01  -4.12672137878685E-01   0.00000000000000E+00   1.30077040584884E-13
     -1.23313482904532E-22  -1.01497641865080E-09  -1.01484634161034E-09  -3.95498380591854E-18
      1.50000000000000E-06
      0.00000000000000E+00  -1.14512018350344E-12   0.00000000000000E+00   6.56338536011641E-15   1.91283342534212E-22
      1.14513997173110E-09   1.14514653511666E-09  -1.06669901647553E-18  -1.02963106255654E-01  -1.02963106255630E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.44764378928093E-11   0.00000000000000E+00  -2.44764378928093E-11
      5.01014825010308E-18  -4.13634697737696E-01  -4.13281653870196E-01   0.00000000000000E+00   1.26702717640178E-13
     -1.23044441285373E-22  -1.12079679994136E-09  -1.12067009722385E-09  -3.94344923362757E-18
}
